/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.transaction.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osivia.demo.transaction.model.CommandNotification;
import org.osivia.demo.transaction.model.Configuration;
import org.osivia.demo.transaction.service.TransactionService;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
public class ViewTransactionController
extends CMSPortlet
implements PortletConfigAware,
PortletContextAware {
    private PortletConfig portletConfig;
    private PortletContext portletContext;
    @Autowired
    private TransactionService service;
    @Autowired
    private INotificationsService notificationsService;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @PreDestroy
    public void preDestroy() {
        super.destroy();
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) {
        return "view";
    }

    @ExceptionHandler
    public String exceptionHandler(PortletRequest request, PortletResponse response) throws PortletException {
        return "error";
    }

    @ModelAttribute(value="configuration")
    public Configuration getConfiguration(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getConfiguration(portalControllerContext);
    }

    @ActionMapping(value="createone")
    public void createOne(ActionRequest request, ActionResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        CommandNotification commandNotification = this.service.createOne(portalControllerContext);
        this.notificationsService.addSimpleNotification(portalControllerContext, commandNotification.getMsgReturn(), commandNotification.isSuccess() ? NotificationsType.SUCCESS : NotificationsType.WARNING);
    }

    @ActionMapping(value="createseveral")
    public void createSeveral(ActionRequest request, ActionResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        CommandNotification commandNotification = this.service.createSeveral(portalControllerContext);
        this.notificationsService.addSimpleNotification(portalControllerContext, commandNotification.getMsgReturn(), commandNotification.isSuccess() ? NotificationsType.SUCCESS : NotificationsType.WARNING);
    }

    @ActionMapping(value="createandupdate")
    public void createAndUpdate(ActionRequest request, ActionResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        CommandNotification commandNotification = this.service.createAndUpdate(portalControllerContext);
        this.notificationsService.addSimpleNotification(portalControllerContext, commandNotification.getMsgReturn(), commandNotification.isSuccess() ? NotificationsType.SUCCESS : NotificationsType.WARNING);
    }

    @ActionMapping(value="createandrollback")
    public void createAndRollback(ActionRequest request, ActionResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        CommandNotification commandNotification = this.service.createAndRollback(portalControllerContext);
        this.notificationsService.addSimpleNotification(portalControllerContext, commandNotification.getMsgReturn(), commandNotification.isSuccess() ? NotificationsType.SUCCESS : NotificationsType.WARNING);
    }

    @ActionMapping(value="deleteandrollback")
    public void deleteAndRollback(ActionRequest request, ActionResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        CommandNotification commandNotification = this.service.deleteAndRollback(portalControllerContext);
        this.notificationsService.addSimpleNotification(portalControllerContext, commandNotification.getMsgReturn(), commandNotification.isSuccess() ? NotificationsType.SUCCESS : NotificationsType.WARNING);
    }

    @ActionMapping(value="createblob")
    public void createBlob(ActionRequest request, ActionResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        CommandNotification commandNotification = this.service.createBlob(portalControllerContext);
        this.notificationsService.addSimpleNotification(portalControllerContext, commandNotification.getMsgReturn(), commandNotification.isSuccess() ? NotificationsType.SUCCESS : NotificationsType.WARNING);
    }

    @ActionMapping(value="createblobs")
    public void createBlobs(ActionRequest request, ActionResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        CommandNotification commandNotification = this.service.createBlobs(portalControllerContext);
        this.notificationsService.addSimpleNotification(portalControllerContext, commandNotification.getMsgReturn(), commandNotification.isSuccess() ? NotificationsType.SUCCESS : NotificationsType.WARNING);
    }

    @ActionMapping(value="fetchPublicationInfo")
    public void fetchPublicationInfo(ActionRequest request, ActionResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        CommandNotification commandNotification = this.service.fetchPublicationInfo(portalControllerContext);
        this.notificationsService.addSimpleNotification(portalControllerContext, commandNotification.getMsgReturn(), commandNotification.isSuccess() ? NotificationsType.SUCCESS : NotificationsType.WARNING);
    }

    @ActionMapping(value="updateAndRollback")
    public void updateAndRollback(ActionRequest request, ActionResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        CommandNotification commandNotification = this.service.updateAndRollback(portalControllerContext);
        this.notificationsService.addSimpleNotification(portalControllerContext, commandNotification.getMsgReturn(), commandNotification.isSuccess() ? NotificationsType.SUCCESS : NotificationsType.WARNING);
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }
}

