/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.transaction.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import javax.naming.NamingException;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.osivia.demo.transaction.model.CommandNotification;
import org.osivia.demo.transaction.model.Configuration;
import org.osivia.demo.transaction.repository.TransactionRepository;
import org.osivia.demo.transaction.repository.command.CreateAndRollbackCommand;
import org.osivia.demo.transaction.repository.command.CreateAndUpdateCommand;
import org.osivia.demo.transaction.repository.command.CreateBlobCommand;
import org.osivia.demo.transaction.repository.command.CreateBlobsCommand;
import org.osivia.demo.transaction.repository.command.DeleteAndRollbackCommand;
import org.osivia.demo.transaction.repository.command.FetchPublicationInfoCommand;
import org.osivia.demo.transaction.repository.command.OneCreationCommand;
import org.osivia.demo.transaction.repository.command.SeveralCreationCommand;
import org.osivia.demo.transaction.repository.command.UpdateAndRollbackCommand;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TransactionRepositoryImpl
implements TransactionRepository {
    private static Logger LOGGER = Logger.getLogger(TransactionRepositoryImpl.class);
    private static final String PORTLET_TRANSACTION_CONFIGURATION = "portlet.transaction.configuration";
    private static final String PROPERTIES_FILE_NAME = "transaction.properties";
    private static final String PATH_PROPERTY = "transaction.path";
    private static final String WEBID = "transaction.webid";
    private final Properties properties = new Properties();

    public TransactionRepositoryImpl() throws IOException, NamingException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE_NAME);
        if (inputStream == null) {
            throw new FileNotFoundException(PROPERTIES_FILE_NAME);
        }
        this.properties.load(inputStream);
    }

    public Configuration getConfiguration(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        Configuration configuration = (Configuration)portalControllerContext.getRequest().getPortletSession().getAttribute(PORTLET_TRANSACTION_CONFIGURATION);
        if (configuration == null) {
            configuration = new Configuration();
            String path = StringUtils.defaultIfEmpty((String)window.getProperty(PATH_PROPERTY), (String)this.properties.getProperty(PATH_PROPERTY));
            String webid = StringUtils.defaultIfEmpty((String)window.getProperty(WEBID), (String)this.properties.getProperty(WEBID));
            configuration.setPath(path);
            configuration.setWebid(webid);
            portalControllerContext.getRequest().getPortletSession().setAttribute(PORTLET_TRANSACTION_CONFIGURATION, (Object)configuration);
        }
        return configuration;
    }

    public void setConfiguration(PortalControllerContext portalControllerContext, Configuration configuration) throws PortletException {
        if (configuration.getPath() == null) {
            configuration.setPath(this.properties.getProperty(PATH_PROPERTY));
        }
        if (configuration.getWebid() == null) {
            configuration.setWebid(this.properties.getProperty(WEBID));
        }
        portalControllerContext.getRequest().getPortletSession().setAttribute(PORTLET_TRANSACTION_CONFIGURATION, (Object)configuration);
    }

    public CommandNotification createOne(PortalControllerContext portalControllerContext) throws PortletException {
        Configuration configuration = this.getConfiguration(portalControllerContext);
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        nuxeoController.setAsynchronousCommand(false);
        CommandNotification commandNotification = (CommandNotification)nuxeoController.executeNuxeoCommand((INuxeoCommand)new OneCreationCommand(configuration, UUID.randomUUID().toString()));
        return commandNotification;
    }

    public CommandNotification createSeveral(PortalControllerContext portalControllerContext) throws PortletException {
        Configuration configuration = this.getConfiguration(portalControllerContext);
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        nuxeoController.setAsynchronousCommand(false);
        CommandNotification commandNotification = (CommandNotification)nuxeoController.executeNuxeoCommand((INuxeoCommand)new SeveralCreationCommand(configuration, UUID.randomUUID().toString()));
        return commandNotification;
    }

    public CommandNotification createAndUpdate(PortalControllerContext portalControllerContext) throws PortletException {
        Configuration configuration = this.getConfiguration(portalControllerContext);
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        nuxeoController.setAsynchronousCommand(false);
        CommandNotification commandNotification = (CommandNotification)nuxeoController.executeNuxeoCommand((INuxeoCommand)new CreateAndUpdateCommand(configuration, UUID.randomUUID().toString()));
        return commandNotification;
    }

    public CommandNotification createAndRollback(PortalControllerContext portalControllerContext) throws PortletException {
        Configuration configuration = this.getConfiguration(portalControllerContext);
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        nuxeoController.setAsynchronousCommand(false);
        CommandNotification commandNotification = (CommandNotification)nuxeoController.executeNuxeoCommand((INuxeoCommand)new CreateAndRollbackCommand(configuration, UUID.randomUUID().toString()));
        return commandNotification;
    }

    public CommandNotification deleteAndRollback(PortalControllerContext portalControllerContext) throws PortletException {
        Configuration configuration = this.getConfiguration(portalControllerContext);
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        nuxeoController.setAsynchronousCommand(false);
        CommandNotification commandNotification = (CommandNotification)nuxeoController.executeNuxeoCommand((INuxeoCommand)new DeleteAndRollbackCommand(configuration, UUID.randomUUID().toString()));
        return commandNotification;
    }

    public CommandNotification createBlob(PortalControllerContext portalControllerContext) throws PortletException {
        Configuration configuration = this.getConfiguration(portalControllerContext);
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        nuxeoController.setAsynchronousCommand(false);
        CommandNotification commandNotification = (CommandNotification)nuxeoController.executeNuxeoCommand((INuxeoCommand)new CreateBlobCommand(configuration, UUID.randomUUID().toString()));
        return commandNotification;
    }

    public CommandNotification createBlobs(PortalControllerContext portalControllerContext) throws PortletException {
        Configuration configuration = this.getConfiguration(portalControllerContext);
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        nuxeoController.setAsynchronousCommand(false);
        CommandNotification commandNotification = (CommandNotification)nuxeoController.executeNuxeoCommand((INuxeoCommand)new CreateBlobsCommand(configuration, UUID.randomUUID().toString()));
        return commandNotification;
    }

    public CommandNotification fetchPublicationInfo(PortalControllerContext portalControllerContext) throws PortletException {
        Configuration configuration = this.getConfiguration(portalControllerContext);
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        nuxeoController.setAsynchronousCommand(false);
        CommandNotification commandNotification = (CommandNotification)nuxeoController.executeNuxeoCommand((INuxeoCommand)new FetchPublicationInfoCommand(configuration, UUID.randomUUID().toString()));
        return commandNotification;
    }

    public CommandNotification updateAndRollback(PortalControllerContext portalControllerContext) throws PortletException {
        Configuration configuration = this.getConfiguration(portalControllerContext);
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        nuxeoController.setAsynchronousCommand(false);
        CommandNotification commandNotification = (CommandNotification)nuxeoController.executeNuxeoCommand((INuxeoCommand)new UpdateAndRollbackCommand(configuration, UUID.randomUUID().toString()));
        return commandNotification;
    }

    private NuxeoController getNuxeoController(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        PortletContext portletContext = portalControllerContext.getPortletCtx();
        return new NuxeoController(request, response, portletContext);
    }
}

