/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.transaction.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.PathRef;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.demo.transaction.model.CommandNotification;
import org.osivia.demo.transaction.model.Configuration;

public class CreateAndRollbackCommand
implements INuxeoCommand {
    private final Configuration configuration;
    String suffix;

    public CreateAndRollbackCommand(Configuration configuration, String suffix) {
        this.configuration = configuration;
        this.suffix = suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Session session) throws Exception {
        CommandNotification commandNotification;
        block12: {
            String txId = null;
            try {
                Object object = session.newRequest("Repository.StartTransaction").execute();
                if (object instanceof FileBlob) {
                    FileBlob txIdAsBlob = (FileBlob)object;
                    txId = IOUtils.toString((InputStream)txIdAsBlob.getStream(), (String)"UTF-8");
                    System.out.println("[TXID]: " + txId + "\n");
                    try {
                        OperationRequest operationRequest = session.newRequest("Document.Create");
                        PropertyMap propertyMap = new PropertyMap();
                        propertyMap.set("ttc:webid", this.configuration.getWebid());
                        Document createdDoc = (Document)operationRequest.setHeader("Tx-conversation-id", txId).setInput((OperationInput)new PathRef(this.configuration.getPath())).set("type", (Object)"Note").set("properties", (Object)propertyMap).execute();
                        System.out.println("Creation DONE: " + createdDoc.getPath() + " | " + createdDoc.getInputRef() + "\n");
                        Document createdDoc2 = (Document)operationRequest.setHeader("Tx-conversation-id", txId).setInput((OperationInput)new PathRef(this.configuration.getPath())).set("type", (Object)"Note").set("properties", (Object)propertyMap).execute();
                        System.out.println("Creation DONE: " + createdDoc2.getPath() + " | " + createdDoc2.getInputRef() + "\n");
                        commandNotification = new CommandNotification(true, "Double cr\u00e9ation r\u00e9ussie");
                        break block12;
                    }
                    catch (Exception e) {
                        session.newRequest("Repository.MarkTransactionAsRollback").setHeader("Tx-conversation-id", txId).execute();
                        System.out.println(e);
                        commandNotification = new CommandNotification(false, "Rollback, cause: " + e.toString());
                        break block12;
                    }
                    finally {
                        session.newRequest("Repository.CommitOrRollbackTransaction").setHeader("Tx-conversation-id", txId).execute();
                    }
                }
                Document document = (Document)object;
                System.out.println("Pas r\u00e9ussi \u00e0 faire l'appel \u00e0 Start Transaction, document" + document.toString());
                commandNotification = new CommandNotification(false, "Pas r\u00e9ussi \u00e0 faire l'appel \u00e0 Start Transaction");
            }
            catch (Exception e) {
                System.out.println(e);
                commandNotification = new CommandNotification(false, "Erreur, cause : " + e.toString());
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        return commandNotification;
    }

    public String getId() {
        return "transaction" + this.suffix;
    }
}

