/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.transaction.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.PathRef;
import org.osivia.demo.transaction.model.CommandNotification;
import org.osivia.demo.transaction.model.Configuration;

public class CreateBlobsCommand
implements INuxeoCommand {
    private final Configuration configuration;
    String suffix;

    public CreateBlobsCommand(Configuration configuration, String suffix) {
        this.configuration = configuration;
        this.suffix = suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Session session) throws Exception {
        CommandNotification commandNotification;
        block12: {
            String txId = null;
            Document createdDoc = null;
            try {
                Object object = session.newRequest("Repository.StartTransaction").execute();
                if (object instanceof FileBlob) {
                    FileBlob txIdAsBlob = (FileBlob)object;
                    txId = IOUtils.toString((InputStream)txIdAsBlob.getStream(), (String)"UTF-8");
                    System.out.println("[TXID]: " + txId + "\n");
                    try {
                        OperationRequest operationRequest = session.newRequest("Document.Create");
                        createdDoc = (Document)operationRequest.setHeader("Tx-conversation-id", txId).setInput((OperationInput)new PathRef(this.configuration.getPath())).set("type", (Object)"Note").execute();
                        System.out.println("Creation DONE: " + createdDoc.getPath() + " | " + createdDoc.getInputRef() + "\n");
                        URL exampleFile1 = this.getClass().getResource("/WEB-INF/classes/example1.doc");
                        URL exampleFile2 = this.getClass().getResource("/WEB-INF/classes/example2.pdf");
                        FileBlob blob1 = new FileBlob(new File(exampleFile1.getFile()));
                        FileBlob blob2 = new FileBlob(new File(exampleFile2.getFile()));
                        ArrayList<FileBlob> blobs = new ArrayList<FileBlob>(2);
                        blobs.add(blob1);
                        blobs.add(blob2);
                        OperationRequest req = session.newRequest("Blob.AttachList").setInput((OperationInput)new Blobs(blobs)).set("document", (Object)createdDoc.getPath());
                        req.setHeader("X-NXVoidOperation", "true");
                        req.setHeader("Tx-conversation-id", txId);
                        req.set("xpath", (Object)"files:files");
                        Document blobAdded = (Document)req.execute();
                        commandNotification = new CommandNotification(true, "2 blobs cr\u00e9\u00e9s avec succ\u00e8s attach\u00e9 au document: " + createdDoc.getInputRef());
                        break block12;
                    }
                    catch (Exception e) {
                        session.newRequest("Repository.MarkTransactionAsRollback").setHeader("Tx-conversation-id", txId).execute();
                        System.out.println(e);
                        commandNotification = new CommandNotification(false, "Erreur, Rollback n\u00e9cessaire, cause:" + e.toString());
                        break block12;
                    }
                    finally {
                        session.newRequest("Repository.CommitOrRollbackTransaction").setHeader("Tx-conversation-id", txId).execute();
                    }
                }
                Document document = (Document)object;
                System.out.println("Pas r\u00e9ussi \u00e0 faire l'appel \u00e0 Start Transaction, document" + document.toString());
                commandNotification = new CommandNotification(false, "Pas r\u00e9ussi \u00e0 faire l'appel \u00e0 Start Transaction");
            }
            catch (Exception e) {
                System.out.println(e);
                commandNotification = new CommandNotification(false, "Erreur, cause : " + e.toString());
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        return commandNotification;
    }

    public String getId() {
        return "transaction" + this.suffix;
    }
}

