/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.transaction.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.PathRef;
import org.osivia.demo.transaction.model.CommandNotification;
import org.osivia.demo.transaction.model.Configuration;

public class UpdateAndRollbackCommand
implements INuxeoCommand {
    private final Configuration configuration;
    String suffix;

    public UpdateAndRollbackCommand(Configuration configuration, String suffix) {
        this.configuration = configuration;
        this.suffix = suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Session session) throws Exception {
        CommandNotification commandNotification;
        block12: {
            String txId = null;
            try {
                Object object = session.newRequest("Repository.StartTransaction").execute();
                if (object instanceof FileBlob) {
                    FileBlob txIdAsBlob = (FileBlob)object;
                    txId = IOUtils.toString((InputStream)txIdAsBlob.getStream(), (String)"UTF-8");
                    System.out.println("[TXID]: " + txId + "\n");
                    try {
                        OperationRequest operationCreateRequest = session.newRequest("Document.TTCCreate");
                        Document createdDoc = (Document)operationCreateRequest.setHeader("Tx-conversation-id", txId).setInput((OperationInput)new PathRef(this.configuration.getPath())).set("type", (Object)"Note").execute();
                        System.out.println("Creation DONE: " + createdDoc.getPath() + " | " + createdDoc.getInputRef() + "\n");
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.put("dc:title", "Document cr\u00e9\u00e9 pour mise a jour et rollback");
                        OperationRequest operationUpdateRequest = session.newRequest("Document.TTCUpdate");
                        createdDoc = (Document)operationUpdateRequest.setHeader("Tx-conversation-id", txId).setInput((OperationInput)createdDoc).set("properties", properties).execute();
                        System.out.println("Update DONE: " + createdDoc.getPath() + " | " + createdDoc.getInputRef() + "\n");
                        session.newRequest("Repository.MarkTransactionAsRollback").setHeader("Tx-conversation-id", txId).execute();
                        commandNotification = new CommandNotification(true, "Cr\u00e9ation, mise \u00e0 jour et rollback r\u00e9alis\u00e9es avec succ\u00e8s");
                        break block12;
                    }
                    catch (Exception e) {
                        session.newRequest("Repository.MarkTransactionAsRollback").setHeader("Tx-conversation-id", txId).execute();
                        System.out.println(e);
                        commandNotification = new CommandNotification(false, "Erreur, Rollback n\u00e9cessaire, cause:" + e.toString());
                        break block12;
                    }
                    finally {
                        session.newRequest("Repository.CommitOrRollbackTransaction").setHeader("Tx-conversation-id", txId).execute();
                    }
                }
                Document document = (Document)object;
                System.out.println("Pas r\u00e9ussi \u00e0 faire l'appel \u00e0 Start Transaction, document" + document.toString());
                commandNotification = new CommandNotification(false, "Pas r\u00e9ussi \u00e0 faire l'appel \u00e0 Start Transaction");
            }
            catch (Exception e) {
                System.out.println(e);
                commandNotification = new CommandNotification(false, "Erreur, cause : " + e.toString());
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        return commandNotification;
    }

    public String getId() {
        return "transaction" + this.suffix;
    }
}

