/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.demo.customizer;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;

public class InternationalizationCustomizerPortlet
extends GenericPortlet
implements ICustomizationModule {
    private static final String CUSTOMIZER_NAME = "osivia.demo.customizer.internationalization.name";
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    private static final String RESOURCE_BUNDLE_NAME = "Resource";
    private ICustomizationModulesRepository repository;
    private final CustomizationModuleMetadatas metadatas = this.generateMetadatas();

    public void init() throws PortletException {
        super.init();
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    public void destroy() {
        super.destroy();
        this.repository.unregister(this.metadatas);
    }

    public void customize(String customizationId, CustomizationContext context) {
        Map attributes = context.getAttributes();
        String key = (String)attributes.get("osivia.customizer.internationalization.key");
        Locale locale = (Locale)attributes.get("osivia.customizer.internationalization.locale");
        if (StringUtils.isNotBlank((String)key) && locale != null) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, locale);
                String result = resourceBundle.getString(key);
                attributes.put("osivia.customizer.internationalization.result", result);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
    }

    private final CustomizationModuleMetadatas generateMetadatas() {
        CustomizationModuleMetadatas metadatas = new CustomizationModuleMetadatas();
        metadatas.setName(CUSTOMIZER_NAME);
        metadatas.setModule((ICustomizationModule)this);
        metadatas.setCustomizationIDs(Arrays.asList("osivia.customizer.internationalization.id"));
        return metadatas;
    }
}

