/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.demo.customizer;

import java.util.Arrays;
import java.util.Map;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;
import org.osivia.portal.api.theming.IRenderedRegions;

public class RegionsCustomizerPortlet
extends GenericPortlet
implements ICustomizationModule {
    private static final String CHARTE_CONTEXT = "customizer.regions.demo.context";
    private static final String CHARTE_SITESWEB_CONTEXT = "customizer.regions.demo.sitesweb.context";
    private static final String CHARTE_MONTPELLIER_CONTEXT = "customizer.regions.demo.montpellier.context";
    private static final String CHARTE_CNS_CONTEXT = "customizer.regions.demo.cns.context";
    private static final String CUSTOMIZER_NAME = "osivia.site.customizer.regions.name";
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    private ICustomizationModulesRepository repository;
    private final CustomizationModuleMetadatas metadatas = this.generateMetadatas();

    private CustomizationModuleMetadatas generateMetadatas() {
        CustomizationModuleMetadatas metadatas = new CustomizationModuleMetadatas();
        metadatas.setName(CUSTOMIZER_NAME);
        metadatas.setModule((ICustomizationModule)this);
        metadatas.setCustomizationIDs(Arrays.asList("osivia.customizer.regions.id"));
        return metadatas;
    }

    public void init() throws PortletException {
        super.init();
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    public void destroy() {
        super.destroy();
        this.repository.unregister(this.metadatas);
    }

    public void customize(String customizationID, CustomizationContext context) {
        String charteEnt = this.getInitParameter(CHARTE_CONTEXT);
        String charteSitesWeb = this.getInitParameter(CHARTE_SITESWEB_CONTEXT);
        String charteMontpellier = this.getInitParameter(CHARTE_MONTPELLIER_CONTEXT);
        String charteCNS = this.getInitParameter(CHARTE_CNS_CONTEXT);
        Map attributes = context.getAttributes();
        String contextPath = (String)attributes.get("osivia.customizer.regions.themeContextPath");
        if (StringUtils.equals((String)contextPath, (String)charteEnt) || StringUtils.equals((String)contextPath, (String)charteSitesWeb) || StringUtils.equals((String)contextPath, (String)charteMontpellier) || StringUtils.equals((String)contextPath, (String)charteCNS)) {
            IRenderedRegions renderedRegion = (IRenderedRegions)attributes.get("osivia.customizer.regions.renderedRegions");
            if (StringUtils.equals((String)contextPath, (String)charteEnt)) {
                renderedRegion.customizeRenderedRegion("logo", "/header/logo.jsp");
                renderedRegion.customizeRenderedRegion("search", "/header/search.jsp");
                renderedRegion.removeRenderedRegion("footer");
            }
            if (StringUtils.equals((String)contextPath, (String)charteSitesWeb)) {
                renderedRegion.customizeRenderedRegion("title", "/header/title.jsp");
                renderedRegion.customizeRenderedRegion("logo", "/header/logo.jsp", charteEnt);
            }
            if (StringUtils.equals((String)contextPath, (String)charteMontpellier)) {
                renderedRegion.customizeRenderedRegion("logo", "/header/logo.jsp", contextPath);
                renderedRegion.removeRenderedRegion("footer");
            }
            if (StringUtils.equals((String)contextPath, (String)charteCNS)) {
                renderedRegion.customizeRenderedRegion("header-metadata", "/header/header-metadata.jsp", contextPath);
                renderedRegion.customizeRenderedRegion("logo", "/header/logo.jsp", contextPath);
                renderedRegion.customizeRenderedRegion("search", "/header/search.jsp", charteCNS);
                renderedRegion.customizeRenderedRegion("tabs", "/header/tabs.jsp", charteCNS);
                renderedRegion.removeRenderedRegion("footer");
            }
        }
    }
}

