/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme;

public final class Orientation {
    public static final Orientation VERTICAL = new Orientation("vertical");
    public static final Orientation HORIZONTAL = new Orientation("horizontal");
    public static final Orientation DEFAULT = VERTICAL;
    private final String value;

    private Orientation(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Orientation) {
            Orientation that = (Orientation)o;
            return this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static Orientation parse(String orientation) {
        if (orientation != null) {
            if (orientation.equalsIgnoreCase(VERTICAL.toString())) {
                return VERTICAL;
            }
            if (orientation.equalsIgnoreCase(HORIZONTAL.toString())) {
                return HORIZONTAL;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }
}

