/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.path.IBrowserService;
import org.osivia.portal.api.portlet.PortalGenericPortlet;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public abstract class CMSPortlet
extends PortalGenericPortlet {
    protected final Log logger = LogFactory.getLog(CMSPortlet.class);
    private final INuxeoService nuxeoService;
    private final ICMSServiceLocator cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
    private final IBrowserService browserService;

    public CMSPortlet() {
        this.nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
        this.browserService = (IBrowserService)Locator.findMBean(IBrowserService.class, (String)"osivia:service=BrowserService");
    }

    public ICMSService getCMSService() {
        return this.cmsServiceLocator.getCMSService();
    }

    public INuxeoService getNuxeoService() {
        return this.nuxeoService;
    }

    @Deprecated
    public INuxeoService getNuxeoNavigationService() throws Exception {
        return this.nuxeoService;
    }

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        try {
            new NuxeoController(this.getPortletContext()).startNuxeoService();
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void destroy() {
        try {
            new NuxeoController(this.getPortletContext()).stopNuxeoService();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        super.destroy();
    }

    public String formatResourceLastModified() {
        SimpleDateFormat inputFormater = new SimpleDateFormat("EEE, yyyy-MM-dd'T'HH:mm:ss.SS'Z'", Locale.ENGLISH);
        inputFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return inputFormater.format(new Date(System.currentTimeMillis()));
    }

    public boolean isResourceExpired(String sOriginalDate, ResourceResponse resourceResponse, String refreshMs) {
        boolean isExpired = true;
        if (sOriginalDate != null) {
            SimpleDateFormat inputFormater = new SimpleDateFormat("EEE, yyyy-MM-dd'T'HH:mm:ss.SS'Z'", Locale.ENGLISH);
            inputFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                Date originalDate = inputFormater.parse(sOriginalDate);
                if (System.currentTimeMillis() < originalDate.getTime() + (long)(resourceResponse.getCacheControl().getExpirationTime() * 1000) && (refreshMs == null || Long.parseLong(refreshMs) < originalDate.getTime())) {
                    isExpired = false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return isExpired;
    }

    public boolean serveResourceByCache(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
        String sOriginalDate = resourceRequest.getProperty("if-modified-since");
        if (sOriginalDate == null) {
            sOriginalDate = resourceRequest.getProperty("If-Modified-Since");
        }
        if (!this.isResourceExpired(sOriginalDate, resourceResponse, resourceRequest.getParameter("refresh"))) {
            resourceResponse.setProperty("portlet.http-status-code", String.valueOf(304));
            resourceResponse.setProperty("Last-Modified", sOriginalDate);
            resourceResponse.getPortletOutputStream().close();
            return true;
        }
        return false;
    }

    protected void serveResourceException(ResourceRequest resourceRequest, ResourceResponse resourceResponse, NuxeoException e) throws PortletException, IOException {
        int httpErrorCode = 0;
        if (e.getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
            httpErrorCode = 404;
            String message = "Resource CMSPortlet " + resourceRequest.getParameterMap() + " not found (error 404).";
            this.logger.error((Object)message);
        } else if (e.getErrorCode() == NuxeoException.ERROR_FORBIDDEN) {
            httpErrorCode = 403;
        }
        if (httpErrorCode == 0) {
            throw e;
        }
        NuxeoController nuxeoController = this.createNuxeoController((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        PortalControllerContext portalCtx = new PortalControllerContext(this.getPortletContext(), (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        String errorUrl = nuxeoController.getPortalUrlFactory().getHttpErrorUrl(portalCtx, httpErrorCode);
        resourceResponse.setProperty("portlet.http-status-code", String.valueOf(302));
        resourceResponse.setProperty("Location", errorUrl);
        resourceResponse.getPortletOutputStream().close();
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
        try {
            if (this.serveResourceByCache(resourceRequest, resourceResponse)) {
                return;
            }
            if ("link".equals(resourceRequest.getParameter("type"))) {
                NuxeoController nuxeoController = new NuxeoController((PortletRequest)resourceRequest, null, this.getPortletContext());
                String id = resourceRequest.getResourceID();
                Document document = nuxeoController.fetchDocument(id);
                resourceResponse.setProperty("portlet.http-status-code", String.valueOf(302));
                resourceResponse.setProperty("Location", document.getString("clink:link"));
                resourceResponse.getPortletOutputStream().close();
            } else if ("fancytreeLazyLoading".equals(resourceRequest.getResourceID())) {
                this.serveResourceFancytreeLazyLoading(resourceRequest, resourceResponse);
            } else {
                resourceResponse.setProperty("portlet.http-status-code", String.valueOf(404));
            }
        }
        catch (NuxeoException e) {
            this.serveResourceException(resourceRequest, resourceResponse, e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void serveResourceFancytreeLazyLoading(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        try {
            String data = this.browserService.browse(portalControllerContext);
            response.setContentType("application/json");
            PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
            printWriter.write(data);
            printWriter.close();
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected NuxeoController createNuxeoController(PortletRequest portletRequest, PortletResponse portletResponse) {
        return new NuxeoController(portletRequest, portletResponse, this.getPortletContext());
    }
}

