/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.jboss.portal.Mode;
import org.jboss.portal.core.admin.ui.AuthorizationBean;
import org.jboss.portal.core.admin.ui.MultiPortalsAuthorizationBean;
import org.jboss.portal.core.admin.ui.PreferenceBean;
import org.jboss.portal.core.admin.ui.PreferencesBean;
import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.instance.InstanceDefinition;
import org.jboss.portal.core.model.instance.NoSuchInstanceException;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.info.ModeInfo;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.portlet.info.PreferenceInfo;
import org.jboss.portal.portlet.info.PreferencesInfo;
import org.jboss.portal.portlet.state.PropertyChange;
import org.jboss.portal.portlet.state.PropertyMap;
import org.jboss.portal.security.spi.provider.DomainConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceManagerBean {
    private final Mode INTERNAL_EDIT_CONTENT = Mode.create((String)"edit_content");
    private InstanceContainer instanceContainer;
    private RoleModule roleModule;
    private DomainConfigurator domainConfigurator;
    private PortalObjectContainer portalObjectContainer;
    private String selectedId;
    private String selectedPlugin;
    private int selectedFrom;
    private Integer selectedRow;
    private int paginationSize;
    private PreferencesBean selectedPrefs;
    private Instance selectedInstance;
    private List<InstanceDefinition> instances;
    private AuthorizationBean auth = new InstanceAuthorizationBean();
    static final Comparator<Instance> INSTANCE_COMPARATOR = new Comparator<Instance>(){

        @Override
        public int compare(Instance i1, Instance i2) {
            return i1.getId().compareToIgnoreCase(i2.getId());
        }
    };

    public RoleModule getRoleModule() {
        return this.roleModule;
    }

    public void setRoleModule(RoleModule roleModule) {
        this.roleModule = roleModule;
    }

    public InstanceContainer getInstanceContainer() {
        return this.instanceContainer;
    }

    public void setInstanceContainer(InstanceContainer instanceContainer) {
        this.instanceContainer = instanceContainer;
    }

    public DomainConfigurator getDomainConfigurator() {
        return this.domainConfigurator;
    }

    public void setDomainConfigurator(DomainConfigurator domainConfigurator) {
        this.domainConfigurator = domainConfigurator;
    }

    public PortalObjectContainer getPortalObjectContainer() {
        return this.portalObjectContainer;
    }

    public void setPortalObjectContainer(PortalObjectContainer poc) {
        this.portalObjectContainer = poc;
    }

    public int getPaginationSize() {
        return this.paginationSize;
    }

    public void setPaginationSize(int paginationSize) {
        this.paginationSize = paginationSize;
    }

    public int getSelectedFrom() {
        return this.selectedFrom;
    }

    public void setSelectedFrom(int selectedFrom) {
        this.selectedFrom = selectedFrom;
    }

    public Integer getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(Integer selectedRow) {
        this.selectedRow = selectedRow;
    }

    public String getSelectedId() {
        return this.selectedId;
    }

    public void setSelectedId(String selectedId) {
        this.selectedId = selectedId;
        int index = this.getInstances().indexOf(this.getSelectedInstance());
        if (index != -1) {
            this.selectedRow = index;
            this.selectedFrom = index / this.paginationSize * this.paginationSize;
        }
    }

    public String getSelectedPlugin() {
        return this.selectedPlugin;
    }

    public void setSelectedPlugin(String selectedPlugin) {
        this.selectedPlugin = selectedPlugin;
    }

    public Instance getSelectedInstance() {
        if (this.selectedInstance == null && this.selectedId != null) {
            this.selectedInstance = this.instanceContainer.getDefinition(this.selectedId);
        }
        return this.selectedInstance;
    }

    public PreferencesBean getSelectedPrefs() {
        Instance selectedInstance = this.getSelectedInstance();
        if (this.selectedPrefs == null && selectedInstance != null) {
            try {
                this.selectedPrefs = new PreferencesBean(true);
                PreferencesInfo prefsInfo = selectedInstance.getPortlet().getInfo().getPreferences();
                Set keys = prefsInfo.getKeys();
                PropertyMap props = selectedInstance.getProperties();
                for (Object o : keys) {
                    String key = (String)o;
                    PreferenceInfo prefInfo = prefsInfo.getPreference(key);
                    List value = props.getProperty(key);
                    this.selectedPrefs.addEntry(prefInfo, value);
                }
            }
            catch (PortletInvokerException e) {
                e.printStackTrace();
            }
        }
        return this.selectedPrefs;
    }

    public AuthorizationBean getAuth() {
        return this.auth;
    }

    private List<InstanceDefinition> getInstances() {
        if (this.instances == null) {
            ArrayList<InstanceDefinition> tmpInstances = new ArrayList<InstanceDefinition>();
            block2: for (InstanceDefinition instance : this.instanceContainer.getDefinitions()) {
                try {
                    Portlet portlet = instance.getPortlet();
                    PortletInfo info = portlet.getInfo();
                    for (ModeInfo modeInfo : info.getCapabilities().getAllModes()) {
                        if (!modeInfo.getMode().equals((Object)this.INTERNAL_EDIT_CONTENT)) continue;
                        continue block2;
                    }
                    tmpInstances.add(instance);
                }
                catch (PortletInvokerException ignore) {}
            }
            Collections.sort(tmpInstances, INSTANCE_COMPARATOR);
            this.instances = tmpInstances;
        }
        return this.instances;
    }

    public Collection<InstanceDefinition> getSelectedInstances() {
        List<InstanceDefinition> list = this.getInstances();
        int to = Math.min(this.selectedFrom + this.paginationSize, list.size());
        return list.subList(this.selectedFrom, to);
    }

    public Map getSelectedInstancesPrefs() {
        HashMap<String, PropertyMap> map = new HashMap<String, PropertyMap>();
        Collection<InstanceDefinition> instances = this.getSelectedInstances();
        for (Instance instance : instances) {
            InstanceDefinition instanceDef = (InstanceDefinition)instance;
            try {
                map.put(instanceDef.getId(), instanceDef.getProperties());
            }
            catch (PortletInvokerException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public int getInstanceCount() {
        return this.getInstances().size();
    }

    public void refresh() {
        this.selectedInstance = null;
        this.instances = null;
    }

    public void selectFrom() {
        Map pmap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        this.selectedFrom = Integer.parseInt((String)pmap.get("from"));
        this.selectedPlugin = null;
        this.selectedId = null;
    }

    public void selectPlugin() {
        Map pmap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        this.selectedPlugin = (String)pmap.get("plugin");
    }

    public void selectInstance() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = ctx.getExternalContext();
        Map params = ectx.getRequestParameterMap();
        this.selectedId = (String)params.get("id");
        this.selectedPlugin = (String)params.get("plugin");
        this.selectedPrefs = null;
    }

    public void selectInstance(ActionEvent e) {
        this.selectInstance();
    }

    public void deleteInstance(ActionEvent ae) {
        try {
            String id = (String)ae.getComponent().getAttributes().get("instanceId");
            if (id != null) {
                this.instanceContainer.destroyDefinition(id);
                this.selectedId = null;
                this.selectedPrefs = null;
                this.selectedFrom = 0;
                this.selectedPlugin = null;
            }
        }
        catch (NoSuchInstanceException e) {
            e.printStackTrace();
        }
        catch (PortletInvokerException e) {
            e.printStackTrace();
        }
    }

    public void updatePrefs() {
        try {
            ArrayList<PropertyChange> tmp = new ArrayList<PropertyChange>();
            List entries = this.selectedPrefs.getEntries();
            for (Object entry1 : entries) {
                PreferenceBean entry = (PreferenceBean)entry1;
                if (!entry.isStale()) continue;
                PropertyChange change = PropertyChange.newUpdate((String)entry.getName(), entry.getValue());
                tmp.add(change);
            }
            PropertyChange[] changes = tmp.toArray(new PropertyChange[tmp.size()]);
            this.getSelectedInstance().setProperties(changes);
        }
        catch (PortletInvokerException e) {
            e.printStackTrace();
        }
        this.selectedId = null;
        this.selectedPrefs = null;
        this.selectedPlugin = null;
    }

    public void cancelPrefs() {
        this.selectedId = null;
        this.selectedPrefs = null;
        this.selectedPlugin = null;
    }

    public class InstanceAuthorizationBean
    extends MultiPortalsAuthorizationBean {
        public DomainConfigurator getDomainConfigurator() {
            return InstanceManagerBean.this.getDomainConfigurator();
        }

        protected String getURI() {
            Instance instance = InstanceManagerBean.this.getSelectedInstance();
            if (instance != null) {
                return instance.getId();
            }
            return null;
        }

        public String getManagedPortalName() {
            Portal portal = InstanceManagerBean.this.portalObjectContainer.getContext().getDefaultPortal();
            return portal.getName();
        }

        public String submit() {
            String stringMessage = "Security has been correctly updated";
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, stringMessage, stringMessage);
            FacesContext.getCurrentInstance().addMessage("status", message);
            InstanceManagerBean.this.selectedId = null;
            InstanceManagerBean.this.selectedPlugin = null;
            return null;
        }

        public String cancel() {
            InstanceManagerBean.this.selectedId = null;
            InstanceManagerBean.this.selectedPlugin = null;
            return null;
        }

        public RoleModule getRoleModule() {
            return InstanceManagerBean.this.roleModule;
        }

        public SelectItem[] getAvailableActions() {
            return new SelectItem[]{new SelectItem((Object)"view", "View"), new SelectItem((Object)"admin", "Admin")};
        }
    }
}

