/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.jbc.cacheprovider;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.StandardQueryCache;
import org.hibernate.cache.UpdateTimestampsCache;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.hibernate.jbc.cacheprovider.CacheProperties;
import org.jboss.hibernate.jbc.cacheprovider.SecondLevelCacheUtil;
import org.jboss.logging.Logger;

public class JBCCache
implements Cache {
    private static final Logger log = Logger.getLogger(JBCCache.class);
    private static final String ITEM = "item";
    private TreeCache cache;
    private final String regionName;
    private final Fqn regionFqn;
    private final TransactionManager transactionManager;
    private boolean queryCacheLocalWritesOnly;
    private boolean localPutsOnly;
    private final CacheProperties cacheProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JBCCache(TreeCache cache, String regionName, CacheProperties cacheProperties, TransactionManager transactionManager) throws CacheException {
        this.cache = cache;
        this.regionName = regionName;
        this.cacheProperties = cacheProperties;
        this.regionFqn = Fqn.fromString((String)SecondLevelCacheUtil.createRegionFqn(regionName, this.cacheProperties.getCacheRegionPrefix()));
        this.transactionManager = transactionManager;
        this.queryCacheLocalWritesOnly = this.cacheProperties.isQueryCacheLocalWritesOnly() && regionName.contains(StandardQueryCache.class.getName());
        boolean bl = this.localPutsOnly = this.cacheProperties.isLocalPutsOnly() && !regionName.contains(UpdateTimestampsCache.class.getName());
        if (cache.getUseRegionBasedMarshalling()) {
            boolean fetchState = cache.getFetchInMemoryState();
            try {
                if (this.queryCacheLocalWritesOnly) {
                    cache.setFetchInMemoryState(false);
                }
                this.activateCacheRegion(this.regionFqn.toString());
            }
            finally {
                if (this.queryCacheLocalWritesOnly) {
                    cache.setFetchInMemoryState(fetchState);
                }
            }
        } else {
            log.debug((Object)"TreeCache is not configured for region based marshalling");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) throws CacheException {
        Transaction tx = this.suspend();
        try {
            Object object = this.read(key);
            return object;
        }
        finally {
            this.resume(tx);
        }
    }

    public Object read(Object key) throws CacheException {
        try {
            return this.cache.get(new Fqn(this.regionFqn, key), (Object)ITEM);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void update(Object key, Object value) throws CacheException {
        try {
            if (this.queryCacheLocalWritesOnly) {
                Option option = new Option();
                option.setCacheModeLocal(true);
                this.cache.put(new Fqn(this.regionFqn, key), (Object)ITEM, value, option);
            } else {
                this.cache.put(new Fqn(this.regionFqn, key), (Object)ITEM, value);
            }
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value) throws CacheException {
        block11: {
            Transaction tx = this.suspend();
            try {
                if (this.queryCacheLocalWritesOnly || this.localPutsOnly) {
                    Option option = new Option();
                    option.setCacheModeLocal(true);
                    this.cache.getInvocationContext().setOptionOverrides(option);
                    try {
                        this.cache.putFailFast(new Fqn(this.regionFqn, key), (Object)ITEM, value, 0L);
                        break block11;
                    }
                    finally {
                        this.cache.getInvocationContext().setOptionOverrides(null);
                    }
                }
                this.cache.putFailFast(new Fqn(this.regionFqn, key), (Object)ITEM, value, 0L);
            }
            catch (TimeoutException te) {
                log.debug((Object)"ignoring write lock acquisition failure");
            }
            catch (Exception e) {
                throw SecondLevelCacheUtil.convertToHibernateException(e);
            }
            finally {
                this.resume(tx);
            }
        }
    }

    private void resume(Transaction tx) {
        try {
            if (tx != null) {
                this.transactionManager.resume(tx);
            }
        }
        catch (Exception e) {
            throw new CacheException("Could not resume transaction", (Throwable)e);
        }
    }

    private Transaction suspend() {
        Transaction tx = null;
        try {
            if (this.transactionManager != null) {
                tx = this.transactionManager.suspend();
            }
        }
        catch (SystemException se) {
            throw new CacheException("Could not suspend transaction", (Throwable)se);
        }
        return tx;
    }

    public void remove(Object key) throws CacheException {
        try {
            if (this.queryCacheLocalWritesOnly) {
                Option option = new Option();
                option.setCacheModeLocal(true);
                this.cache.remove(new Fqn(this.regionFqn, key), option);
            } else {
                this.cache.remove(new Fqn(this.regionFqn, key));
            }
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void clear() throws CacheException {
        try {
            this.cache.remove(this.regionFqn);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void destroy() throws CacheException {
        try {
            Option opt = new Option();
            opt.setCacheModeLocal(true);
            this.cache.remove(this.regionFqn, opt);
            if (this.cache.getUseRegionBasedMarshalling() && !SecondLevelCacheUtil.isSharedClassLoaderRegion(this.regionName)) {
                this.inactivateCacheRegion();
            }
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void lock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public void unlock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        try {
            Set children = this.cache.getChildrenNames(this.regionFqn);
            return children == null ? 0L : (long)children.size();
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map toMap() {
        try {
            HashMap result = new HashMap();
            Set childrenNames = this.cache.getChildrenNames(this.regionFqn);
            if (childrenNames != null) {
                for (Object key : childrenNames) {
                    result.put(key, this.cache.get(new Fqn(this.regionFqn, key), (Object)ITEM));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public String toString() {
        return "JBCCache(" + this.regionName + ')';
    }

    private void activateCacheRegion(String regionName) throws CacheException {
        String fqnString = this.regionFqn.toString();
        if (this.cache.getMarshaller().isInactive(fqnString)) {
            try {
                if (!SecondLevelCacheUtil.isSharedClassLoaderRegion(regionName)) {
                    this.cache.registerClassLoader(fqnString, Thread.currentThread().getContextClassLoader());
                }
                this.cache.activateRegion(fqnString);
            }
            catch (Exception e) {
                throw SecondLevelCacheUtil.convertToHibernateException(e);
            }
        } else {
            log.debug((Object)("activateCacheRegion(): Region " + fqnString + " is already active"));
        }
    }

    private void inactivateCacheRegion() throws CacheException {
        String fqnString = this.regionFqn.toString();
        if (!this.cache.getMarshaller().isInactive(fqnString)) {
            try {
                this.cache.inactivateRegion(fqnString);
                this.cache.unregisterClassLoader(fqnString);
            }
            catch (Exception e) {
                throw SecondLevelCacheUtil.convertToHibernateException(e);
            }
        } else {
            log.debug((Object)("inactivateCacheRegion(): Region " + fqnString + " is already inactive"));
        }
    }
}

