/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.widget.netvibes.provider;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.common.net.URLTools;
import org.jboss.portal.common.text.FastURLEncoder;
import org.jboss.portal.widget.exceptions.WidgetException;
import org.jboss.portal.widget.exceptions.WidgetFetchException;
import org.jboss.portal.widget.exceptions.WidgetMetaDataParseException;
import org.jboss.portal.widget.exceptions.WidgetNotSupportedException;
import org.jboss.portal.widget.netvibes.NetvibesMetaData;
import org.jboss.portal.widget.netvibes.NetvibesPreferenceInfo;
import org.jboss.portal.widget.netvibes.NetvibesPreferencesInfo;
import org.jboss.portal.widget.netvibes.NetvibesWidgetInfo;
import org.jboss.portal.widget.netvibes.json.JSONArray;
import org.jboss.portal.widget.netvibes.json.JSONException;
import org.jboss.portal.widget.netvibes.json.JSONObject;
import org.jboss.portal.widget.netvibes.json.JSONObjectWrapper;
import org.jboss.portal.widget.netvibes.type.NVBooleanType;
import org.jboss.portal.widget.netvibes.type.NVDataType;
import org.jboss.portal.widget.netvibes.type.NVHiddenType;
import org.jboss.portal.widget.netvibes.type.NVListType;
import org.jboss.portal.widget.netvibes.type.NVPasswordType;
import org.jboss.portal.widget.netvibes.type.NVRangeType;
import org.jboss.portal.widget.netvibes.type.NVTextType;
import org.jboss.portal.widget.netvibes.type.NVTextareaType;

public class NetvibesJSONInfoBuilder {
    private final URL url;
    private static final String COULD_NOT_PARSE = "/* String could not be parsed as XML */ null";

    public NetvibesJSONInfoBuilder(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Url must not be null.");
        }
        this.url = url;
    }

    private URL buildNetvibesJSONUrl(URL url) throws MalformedURLException {
        StringBuffer jsonUrl = new StringBuffer();
        jsonUrl.append("http://www.netvibes.com/api/uwa/compile/uwa_json.php?moduleUrl=");
        jsonUrl.append(FastURLEncoder.getUTF8Instance().encode(url.toString()));
        return new URL(jsonUrl.toString());
    }

    public NetvibesWidgetInfo create() throws WidgetException {
        try {
            byte[] bytes = this.obtainWidget(this.url);
            if (bytes == null) {
                throw new WidgetFetchException("Could not retreive widget: " + this.url.toString());
            }
            if (Arrays.equals(bytes, COULD_NOT_PARSE.getBytes())) {
                throw new WidgetMetaDataParseException("Could not parse widget meta data: " + this.url.toString());
            }
            JSONObject jsonResponse = new JSONObject(new String(bytes));
            LocalizedString title = new LocalizedString(jsonResponse.getString("title"));
            if (title == null) {
                throw new WidgetMetaDataParseException("Unsupported widget format: " + this.url.toString());
            }
            ArrayList iconList = null;
            try {
                iconList = this.parseIcons(jsonResponse.getJSONObject("icon"));
            }
            catch (JSONException e) {
                iconList = new ArrayList();
            }
            JSONObjectWrapper metadata = new JSONObjectWrapper(jsonResponse.getJSONObject("metas"));
            LocalizedString description = null;
            if (((JSONObject)metadata).getString("description") != null) {
                description = new LocalizedString(((JSONObject)metadata).getString("description"));
            }
            NetvibesMetaData md = new NetvibesMetaData(((JSONObject)metadata).getString("author"), ((JSONObject)metadata).getString("website"), description, ((JSONObject)metadata).getString("version"), ((JSONObject)metadata).getString("keywords"), ((JSONObject)metadata).getString("screenshot"), ((JSONObject)metadata).getString("thumbnail"), ((JSONObject)metadata).getString("apiVersion"), ((JSONObject)metadata).getBoolean("debugMode"), ((JSONObject)metadata).getInt("autoRefresh"), ((JSONObject)metadata).getBoolean("inline"));
            int version = ((JSONObject)metadata).getInt("apiVersion");
            if (version < 1) {
                throw new WidgetNotSupportedException("Not supported widget version.");
            }
            ArrayList<NetvibesPreferenceInfo> preferences = new ArrayList<NetvibesPreferenceInfo>();
            JSONArray array = jsonResponse.getJSONArray("preferences");
            for (int i = 0; i < array.length(); ++i) {
                JSONObjectWrapper preference = new JSONObjectWrapper(array.getJSONObject(i));
                NVDataType type = null;
                int dataType = NVDataType.parseDataTypeLiteral(((JSONObject)preference).getString("type"));
                switch (dataType) {
                    case 0: {
                        type = NVTextType.getInstance();
                        break;
                    }
                    case 1: {
                        type = NVBooleanType.getInstance();
                        break;
                    }
                    case 2: {
                        type = NVHiddenType.getInstance();
                        break;
                    }
                    case 5: {
                        type = NVPasswordType.getInstance();
                        break;
                    }
                    case 6: {
                        type = NVTextareaType.getInstance();
                        break;
                    }
                    case 3: {
                        type = new NVRangeType(((JSONObject)preference).getInt("min"), ((JSONObject)preference).getInt("max"), ((JSONObject)preference).getInt("step"));
                        break;
                    }
                    case 4: {
                        ArrayList<NVListType.NVListValue> valueList = new ArrayList<NVListType.NVListValue>();
                        JSONArray values = preference.getJSONArray("options");
                        for (int j = 0; j < values.length(); ++j) {
                            JSONObject value = values.getJSONObject(j);
                            String key = value.getString("value");
                            LocalizedString label = new LocalizedString(value.getString("label"));
                            NVListType.NVListValue nvValue = new NVListType.NVListValue(key, label);
                            valueList.add(nvValue);
                        }
                        type = new NVListType(valueList);
                    }
                }
                NetvibesPreferenceInfo info = new NetvibesPreferenceInfo(((JSONObject)preference).getString("name"), ((JSONObject)preference).getString("label"), type, ((JSONObject)preference).getString("onchange"), ((JSONObject)preference).getString("defaultValue"));
                preferences.add(info);
            }
            NetvibesPreferencesInfo preferencesInfo = new NetvibesPreferencesInfo(preferences);
            NetvibesWidgetInfo info = new NetvibesWidgetInfo(title, iconList, md, preferencesInfo);
            return info;
        }
        catch (JSONException e) {
            throw new WidgetMetaDataParseException("Could not parse widget meta data: " + this.url.toString(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new WidgetFetchException("Unable to build url.", (Throwable)e);
        }
    }

    private List parseIcons(JSONObject icons) throws JSONException {
        ArrayList<String> iconList = new ArrayList<String>();
        for (int i = 0; i < icons.length(); ++i) {
            iconList.add(icons.getString(String.valueOf(i)));
        }
        return iconList;
    }

    public URL getUrl() {
        return this.url;
    }

    protected byte[] obtainWidget(URL url) throws IllegalArgumentException, MalformedURLException {
        return this.obtainURL(url);
    }

    private byte[] obtainURL(URL url) throws IllegalArgumentException, MalformedURLException {
        return URLTools.getContent((URL)this.buildNetvibesJSONUrl(url), (int)5000, (int)5000);
    }
}

