/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.widget.netvibes.provider;

import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.portal.common.text.FastURLEncoder;
import org.jboss.portal.widget.WidgetQuery;

public class NetvibesQuery
implements WidgetQuery {
    private static final Logger log = Logger.getLogger(NetvibesQuery.class);
    private final int start;
    private int count = 10;
    private final String cat;
    private final String type = "uwa";
    private final String sort;
    private final String q;
    private int hashCode;

    public NetvibesQuery(int start, int num, String cat, String sort, String q) {
        if (start < 0) {
            throw new IllegalArgumentException("No negative start");
        }
        if (cat != null && cat.length() == 0) {
            cat = null;
        }
        if (q != null && q.length() == 0) {
            q = null;
        }
        this.start = start;
        this.count = num;
        this.cat = cat;
        this.sort = sort;
        this.q = q;
        this.hashCode = start + num + (cat == null ? 0 : 1 + cat.hashCode()) + (q == null ? 0 : 1 + q.hashCode()) + (sort == null ? 0 : 1 + sort.hashCode());
    }

    public int getStart() {
        return this.start;
    }

    public int getNum() {
        return this.count;
    }

    public String getCat() {
        return this.cat;
    }

    public String getQ() {
        return this.q;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NetvibesQuery) {
            NetvibesQuery that = (NetvibesQuery)obj;
            return this.start == that.start && this.count == that.count && (this.cat == null ? that.cat == null : this.cat.equals(that.cat)) && (this.q == null ? that.q == null : this.q.equals(that.q)) && (this.sort == null ? that.sort == null : this.sort.equals(that.sort));
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public URL buildQueryURL() throws MalformedURLException {
        StringBuffer buffer = new StringBuffer("http://api.eco.netvibes.com/search/?type=uwa");
        if (this.start > 0) {
            buffer.append("&page=").append(this.start);
        }
        if (this.count > 0) {
            buffer.append("&limit=").append(this.count);
        }
        if (this.cat != null) {
            buffer.append("&category=").append(this.cat);
        }
        if (this.sort != null) {
            buffer.append("&sort=").append(this.sort);
        }
        if (this.q != null) {
            buffer.append("&query=").append(FastURLEncoder.getUTF8Instance().encode(this.q));
        }
        return new URL(buffer.toString());
    }
}

