/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.deploiement;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.core.deployment.jboss.PortletAppDeployment;
import org.jboss.portal.core.deployment.jboss.PortletAppDeploymentFactory;
import org.jboss.portal.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.osivia.portal.api.cache.services.ICacheService;
import org.osivia.portal.api.contribution.IContributionService;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.status.IStatusService;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.formatters.IFormatter;
import org.osivia.portal.core.profils.IProfilManager;
import org.osivia.portal.core.web.IWebIdService;

public class PortletApplicationDeployment
extends PortletAppDeployment {
    public PortletApplicationDeployment(URL url, PortalWebApp pwa, ManagedObjectRegistryEventListener listener, MBeanServer mbeanServer, PortletAppDeploymentFactory factory) {
        super(url, pwa, listener, mbeanServer, factory);
    }

    public void start() throws DeploymentException {
        this.injectStandardService("CacheService", ICacheService.class.getName(), "osivia:service=CacheServices");
        this.injectStandardService("StatusService", IStatusService.class.getName(), "osivia:service=StatusServices");
        this.injectStandardService("UrlService", IPortalUrlFactory.class.getName(), "osivia:service=UrlFactory");
        this.injectStandardService("webIdService", IWebIdService.class.getName(), "osivia:service=webIdService");
        this.injectStandardService("ProfileService", IProfilManager.class.getName(), "osivia:service=ProfilManager");
        this.injectStandardService("FormatterService", IFormatter.class.getName(), "osivia:service=Interceptor,type=Command,name=AssistantPageCustomizer");
        this.injectStandardService("NotificationsService", INotificationsService.class.getName(), "osivia:service=NotificationsService");
        this.injectStandardService("InternationalizationService", IInternationalizationService.class.getName(), "osivia:service=InternationalizationService");
        this.injectStandardService("ContributionService", IContributionService.class.getName(), "osivia:service=ContributionService");
        this.injectStandardService("DirctoryServiceLocator", IDirectoryServiceLocator.class.getName(), "osivia:service=DirectoryServiceLocator");
        this.injectStandardService("NuxeoService", "fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService", "osivia:service=NuxeoService");
        BufferedInputStream source = null;
        try {
            source = IOTools.safeBufferedWrapper((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/theme/osivia-portal.tld"));
            this.pwa.importFile("/WEB-INF/theme", "osivia-portal.tld", (InputStream)source, false);
            source = IOTools.safeBufferedWrapper((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/theme/internationalization.tld"));
            this.pwa.importFile("/WEB-INF/theme", "internationalization.tld", (InputStream)source, false);
            source = IOTools.safeBufferedWrapper((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/theme/spring.tld"));
            this.pwa.importFile("/WEB-INF/theme", "spring.tld", (InputStream)source, false);
            source = IOTools.safeBufferedWrapper((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/theme/spring-form.tld"));
            this.pwa.importFile("/WEB-INF/theme", "spring-form.tld", (InputStream)source, false);
            source = IOTools.safeBufferedWrapper((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/theme/displaytag.tld"));
            this.pwa.importFile("/WEB-INF/theme", "displaytag.tld", (InputStream)source, false);
            source = IOTools.safeBufferedWrapper((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/theme/displaytag-el.tld"));
            this.pwa.importFile("/WEB-INF/theme", "displaytag-el.tld", (InputStream)source, false);
        }
        catch (IOException e) {
            try {
                throw new DeploymentException("Cannot import taglib", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOTools.safeClose(source);
                throw throwable;
            }
        }
        IOTools.safeClose((Closeable)source);
        super.start();
    }

    protected void injectStandardService(String serviceName, String serviceClass, String serviceRef) {
        try {
            Class<?> proxyClass = this.pwa.getClassLoader().loadClass(serviceClass);
            ObjectName objectName = ObjectName.getInstance(serviceRef);
            Object proxy = MBeanProxyExt.create(proxyClass, (ObjectName)objectName, (MBeanServer)this.mbeanServer);
            this.pwa.getServletContext().setAttribute(serviceName, proxy);
        }
        catch (Exception e) {
            this.log.error((Object)"Was not able to create service proxy", (Throwable)e);
        }
    }
}

