/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.identity;

import java.util.HashSet;
import java.util.Set;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.db.HibernateRoleModuleImpl;
import org.jboss.portal.security.SecurityConstants;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.profils.FilteredRole;
import org.osivia.portal.core.profils.IProfilManager;
import org.osivia.portal.core.profils.ProfilBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredRoleModule
extends HibernateRoleModuleImpl {
    public Set<Role> findRoles() throws IdentityException {
        HashSet<Role> filteredRoles = new HashSet<Role>();
        try {
            IProfilManager profilManager = (IProfilManager)Locator.findMBean(IProfilManager.class, (String)"osivia:service=ProfilManager");
            for (ProfilBean profil : profilManager.getListeProfils()) {
                try {
                    Role role = super.findRoleByName(profil.getRoleName());
                    filteredRoles.add(role);
                }
                catch (Exception e) {}
            }
            filteredRoles.add(new FilteredRole(SecurityConstants.AUTHENTICATED_ROLE_NAME, "Utilisateurs connect\u00e9s"));
            if (System.getProperty("ldap.groupes_profils_obligatoires") != null) {
                filteredRoles.add(new FilteredRole("role-aucun-profil", "Utilisateurs sans profil"));
            }
        }
        catch (Exception e) {
            throw new IdentityException("No profil service defined");
        }
        return filteredRoles;
    }

    public Role findRoleByName(String name) throws IdentityException {
        if (SecurityConstants.AUTHENTICATED_ROLE_NAME.equals(name)) {
            return new FilteredRole(SecurityConstants.AUTHENTICATED_ROLE_NAME, "Utilisateurs connect\u00e9s");
        }
        if ("role-aucun-profil".equals(name)) {
            return new FilteredRole("role-aucun-profil", "Utilisateurs sans profil");
        }
        if ("Administrators".equals(name)) {
            return new FilteredRole("Administrators", "Administrators");
        }
        return super.findRoleByName(name);
    }
}

