/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.tag;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;

public class InternationalizationServiceTagHandler
extends SimpleTagSupport {
    private static final String BUNDLE_FACTORY_ATTRIBUTE_NAME = "osivia.internationalization.bundleFactory";
    private static final String SEPARATOR = ",";
    private String key;
    private String args;

    public void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        Locale locale = pageContext.getRequest().getLocale();
        IBundleFactory bundleFactory = (IBundleFactory)pageContext.getAttribute(BUNDLE_FACTORY_ATTRIBUTE_NAME, 4);
        if (bundleFactory == null) {
            IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            bundleFactory = internationalizationService.getBundleFactory(classLoader);
            pageContext.setAttribute(BUNDLE_FACTORY_ATTRIBUTE_NAME, (Object)4);
        }
        Object[] arguments = StringUtils.split((String)this.args, (String)SEPARATOR);
        Bundle bundle = bundleFactory.getBundle(locale);
        String property = bundle.getString(this.key, arguments);
        JspWriter out = pageContext.getOut();
        out.write(property);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }
}

