/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.aspects.controller;

import org.jboss.logging.Logger;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerInterceptor;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.SecurityException;
import org.jboss.portal.core.controller.command.response.SecurityErrorResponse;
import org.jboss.portal.security.PortalSecurityException;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManagerFactory;

public final class PolicyEnforcementInterceptor
extends ControllerInterceptor {
    private static Logger log = Logger.getLogger(PolicyEnforcementInterceptor.class);
    protected boolean isTrace = log.isTraceEnabled();

    public ControllerResponse invoke(ControllerCommand cmd) throws Exception, InvocationException {
        try {
            PortalAuthorizationManagerFactory pamf = cmd.getControllerContext().getController().getPortalAuthorizationManagerFactory();
            PortalAuthorizationManager pam = pamf.getManager();
            cmd.enforceSecurity(pam);
        }
        catch (PortalSecurityException e) {
            return new SecurityErrorResponse(e, 0, true);
        }
        catch (SecurityException e) {
            return new SecurityErrorResponse(e, 0, false);
        }
        return (ControllerResponse)cmd.invokeNext();
    }
}

