/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.aspects.server;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.core.identity.cache.IdentityCacheService;
import org.jboss.portal.server.ServerInterceptor;
import org.jboss.portal.server.ServerInvocation;

public class IdentityCacheInterceptor
extends ServerInterceptor {
    private static final Logger log = Logger.getLogger(IdentityCacheInterceptor.class);
    private IdentityCacheService identityCacheService;

    public IdentityCacheService getIdentityCacheService() {
        if (this.identityCacheService == null) {
            try {
                this.identityCacheService = (IdentityCacheService)new InitialContext().lookup("java:portal/IdentityCacheService");
            }
            catch (NamingException e) {
                log.debug((Object)"Could not obtain IdentityCacheService. Setting empty wrapper");
                this.identityCacheService = new EmptyIdentityCache();
            }
        }
        return this.identityCacheService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(ServerInvocation invocation) throws Exception, InvocationException {
        try {
            invocation.invokeNext();
        }
        finally {
            IdentityCacheService cache = this.getIdentityCacheService();
            if (cache != null) {
                cache.cleanup();
            }
        }
    }

    private class EmptyIdentityCache
    extends IdentityCacheService {
        private EmptyIdentityCache() {
        }

        public void cleanup() {
        }
    }
}

