/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.instance;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jboss.portal.core.impl.model.instance.AbstractInstanceCustomization;
import org.jboss.portal.core.impl.model.instance.AbstractInstanceDefinition;
import org.jboss.portal.core.impl.model.instance.InstanceContainerContext;
import org.jboss.portal.core.impl.model.instance.InstanceContainerImpl;
import org.jboss.portal.core.impl.model.instance.InstanceContextImpl;
import org.jboss.portal.core.impl.model.instance.JBossInstanceContainerContext;
import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.instance.InstanceCustomization;
import org.jboss.portal.core.model.instance.InstanceDefinition;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletContext;
import org.jboss.portal.portlet.PortletInvoker;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.spi.InstanceContext;
import org.jboss.portal.portlet.state.AccessMode;
import org.jboss.portal.portlet.state.DestroyCloneFailure;
import org.jboss.portal.portlet.state.PropertyChange;
import org.jboss.portal.portlet.state.PropertyMap;

public abstract class AbstractInstance
implements Instance {
    private static final Logger log = Logger.getLogger(AbstractInstance.class);
    protected String portletRef;
    protected byte[] state;
    protected PortletContext portletContext;

    protected AbstractInstance() {
    }

    public String getPortletRef() {
        return this.portletRef;
    }

    public void setPortletRef(String portletRef) {
        this.portletRef = portletRef;
        this.portletContext = null;
    }

    public byte[] getState() {
        return this.state;
    }

    public void setState(byte[] state) {
        this.state = state;
        this.portletContext = null;
    }

    public final PortletContext getPortletContext() {
        if (this.portletContext == null) {
            this.portletContext = PortletContext.createPortletContext((String)this.portletRef, (byte[])this.state);
        }
        return this.portletContext;
    }

    public final boolean isModifiable() {
        return this.isMutable();
    }

    protected abstract boolean isMutable();

    protected abstract void setMutable(boolean var1);

    protected abstract Logger getLogger();

    protected abstract AccessMode getAccessMode();

    protected abstract void cloned(PortletContext var1);

    protected abstract AbstractInstanceDefinition getOwner();

    protected abstract InstanceContainerContext getContainerContext();

    protected abstract String getInstanceId();

    protected final void modified(PortletContext portletContext) {
        this.getContainerContext().updateInstance(this, portletContext);
    }

    public final InstanceDefinition getDefinition() {
        return this.getOwner();
    }

    public final Portlet getPortlet() throws PortletInvokerException {
        PortletInvoker invoker = this.getContainer().getPortletInvoker();
        PortletContext ctx = this.getOwner().getPortletContext();
        return invoker.getPortlet(ctx);
    }

    public final InstanceContainer getContainer() {
        return ((JBossInstanceContainerContext)this.getContainerContext()).getContainer();
    }

    public final void setProperties(PropertyChange[] changes) throws PortletInvokerException {
        if (changes == null) {
            throw new IllegalArgumentException("No null changes accepted");
        }
        boolean debug = this.getLogger().isDebugEnabled();
        PortletInvoker portletInvoker = this.getContainer().getPortletInvoker();
        PortletContext portletContext = this.getPortletContext();
        if (!this.isModifiable()) {
            if (debug) {
                this.getLogger().debug((Object)("Need to clone non modifiable instance before setting properties " + portletContext));
            }
            portletContext = portletInvoker.createClone(portletContext);
            if (debug) {
                this.getLogger().debug((Object)("Received updated portlet context " + portletContext + " for instance " + " after explicit clone"));
            }
            this.getContainerContext().updateInstance(this, portletContext, true);
        }
        if (debug) {
            this.getLogger().debug((Object)("Setting properties on " + portletContext + " : " + Arrays.asList(changes)));
        }
        portletContext = portletInvoker.setProperties(portletContext, changes);
        if (debug) {
            this.getLogger().debug((Object)("Received updated portlet context " + portletContext + " for instance " + " after setting properties"));
        }
        this.getContainerContext().updateInstance(this, portletContext);
    }

    public final PropertyMap getProperties() throws PortletInvokerException {
        PortletInvoker invoker = this.getContainer().getPortletInvoker();
        PortletContext portletContext = this.getPortletContext();
        return invoker.getProperties(portletContext);
    }

    public final PropertyMap getProperties(Set keys) throws PortletInvokerException {
        PortletInvoker invoker = this.getContainer().getPortletInvoker();
        PortletContext portletContext = this.getPortletContext();
        return invoker.getProperties(portletContext, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
        boolean debug = this.getLogger().isDebugEnabled();
        AbstractInstance instance = this;
        AccessMode accessMode = this.getAccessMode();
        PortletContext portletContext = instance.getPortletContext();
        InstanceContextImpl instanceContext = new InstanceContextImpl(this, accessMode);
        try {
            invocation.setAttribute("instanceid", (Object)this.getInstanceId());
            invocation.setTarget(portletContext);
            invocation.setInstanceContext((InstanceContext)instanceContext);
            InstanceContainerImpl container = (InstanceContainerImpl)this.getContainer();
            PortletInvocationResponse response = container.invoke(invocation);
            if (instanceContext.accessMode == AccessMode.CLONE_BEFORE_WRITE) {
                if (instanceContext.clonedContext != null) {
                    if (debug) {
                        // empty if block
                    }
                    this.cloned(instanceContext.clonedContext);
                }
            } else if (instanceContext.accessMode == AccessMode.READ_WRITE && instanceContext.modifiedContext != null) {
                if (debug) {
                    // empty if block
                }
                this.modified(instanceContext.modifiedContext);
            }
            PortletInvocationResponse portletInvocationResponse = response;
            return portletInvocationResponse;
        }
        finally {
            invocation.removeAttribute((Object)"instanceid");
            invocation.setTarget(null);
            invocation.setInstanceContext(null);
        }
    }

    public final InstanceCustomization getCustomization(String customizationId) {
        if (customizationId == null) {
            throw new IllegalArgumentException();
        }
        AbstractInstanceCustomization customization = this.getContainerContext().getCustomization(this.getOwner(), customizationId);
        if (customization == null) {
            AbstractInstanceDefinition def = this.getOwner();
            customization = this.getContainerContext().newInstanceCustomization(def, customizationId, this.getPortletContext());
        }
        return customization;
    }

    public final void destroyCustomization(String customizationId) {
        AbstractInstanceCustomization customization = this.getContainerContext().getCustomization(this.getOwner(), customizationId);
        if (customization != null) {
            try {
                PortletContext customizationPortletContext = customization.getPortletContext();
                List<PortletContext> toDestroy = Collections.singletonList(customizationPortletContext);
                PortletInvoker portletInvoker = this.getContainer().getPortletInvoker();
                this.getContainerContext().destroyInstanceCustomization(customization);
                List failures = portletInvoker.destroyClones(toDestroy);
                if (failures.size() > 0) {
                    for (DestroyCloneFailure failure : failures) {
                        log.error((Object)("Was not able to destroy " + failure.getPortletId() + " for customization " + customizationId + ", reason is : " + failure.getMessage()));
                    }
                }
            }
            catch (PortletInvokerException e) {
                log.error((Object)("Could not destroy customization " + customizationId), (Throwable)e);
            }
        }
    }
}

