/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal;

import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.command.mapper.AbstractCommandFactory;
import org.jboss.portal.core.model.portal.Context;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.command.PageCommand;
import org.jboss.portal.core.model.portal.command.action.ImportPageToDashboardCommand;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowActionCommand;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowRenderCommand;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowResourceCommand;
import org.jboss.portal.core.model.portal.command.mapping.PortalObjectPathMapper;
import org.jboss.portal.core.model.portal.command.view.ViewContextCommand;
import org.jboss.portal.core.model.portal.command.view.ViewPageCommand;
import org.jboss.portal.core.model.portal.command.view.ViewPortalCommand;
import org.jboss.portal.core.model.portal.navstate.WindowNavigationalState;
import org.jboss.portal.core.navstate.NavigationalStateKey;
import org.jboss.portal.core.portlet.PortletRequestDecoder;
import org.jboss.portal.server.ServerInvocation;

public class PortalObjectCommandFactory
extends AbstractCommandFactory {
    private PortalObjectPathMapper mapper;

    public PortalObjectPathMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(PortalObjectPathMapper mapper) {
        this.mapper = mapper;
    }

    public ControllerCommand doMapping(ControllerContext controllerContext, ServerInvocation invocation, String host, String contextPath, String requestPath) {
        PageCommand cmd;
        if (requestPath == null) {
            return null;
        }
        PortalObject target = this.mapper.getTarget(controllerContext, requestPath);
        ParameterMap queryParams = invocation.getServerContext().getQueryParameterMap();
        if (target instanceof Window) {
            Window window = (Window)target;
            PortletRequestDecoder decoder = new PortletRequestDecoder();
            decoder.decode((Map<String, String[]>)queryParams, (Map<String, String[]>)invocation.getServerContext().getBodyParameterMap());
            if (decoder.getType() == 3) {
                cmd = new InvokePortletWindowResourceCommand(window.getId(), decoder.getCacheability(), decoder.getResourceId(), decoder.getResourceState(), decoder.getForm());
            } else {
                Mode mode;
                WindowState windowState;
                NavigationalStateKey nsKey = new NavigationalStateKey(WindowNavigationalState.class, window.getId());
                WindowNavigationalState windowNavState = (WindowNavigationalState)controllerContext.getAttribute(ControllerCommand.NAVIGATIONAL_STATE_SCOPE, nsKey);
                if (windowNavState == null) {
                    windowNavState = WindowNavigationalState.create();
                    controllerContext.setAttribute(ControllerCommand.NAVIGATIONAL_STATE_SCOPE, nsKey, windowNavState);
                }
                if ((windowState = decoder.getWindowState()) == null) {
                    windowState = windowNavState.getWindowState();
                }
                if ((mode = decoder.getMode()) == null) {
                    mode = windowNavState.getMode();
                }
                switch (decoder.getType()) {
                    case 2: {
                        cmd = new InvokePortletWindowRenderCommand(window.getId(), mode, windowState);
                        break;
                    }
                    case 0: {
                        cmd = new InvokePortletWindowActionCommand(window.getId(), mode, windowState, decoder.getNavigationalState(), decoder.getInteractionState(), decoder.getForm());
                        break;
                    }
                    case 1: {
                        cmd = new InvokePortletWindowRenderCommand(window.getId(), mode, windowState, decoder.getNavigationalState());
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        } else {
            if (target instanceof Context) {
                Context context = (Context)target;
                return new ViewContextCommand(context.getId());
            }
            if (target instanceof Portal) {
                Portal portal = (Portal)target;
                return new ViewPortalCommand(portal.getId());
            }
            Page page = (Page)target;
            PortalObjectId id = page.getId();
            String action = queryParams.getValue("action");
            cmd = "import".equals(action) ? new ImportPageToDashboardCommand(id) : new ViewPageCommand(id, (Map<String, String[]>)queryParams);
        }
        return cmd;
    }
}

