/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.command.action;

import java.util.Comparator;
import java.util.Iterator;
import org.jboss.portal.common.util.ListMap;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.command.info.ActionCommandInfo;
import org.jboss.portal.core.controller.command.info.CommandInfo;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.command.WindowCommand;
import org.jboss.portal.theme.ThemeTools;

public class MoveWindowCommand
extends WindowCommand {
    private static final CommandInfo info = new ActionCommandInfo(false);
    private int fromPos;
    private String fromRegion;
    private int toPos;
    private String toRegion;
    private static final Comparator tmp = new Comparator(){

        public int compare(Object o1, Object o2) {
            Window window1 = (Window)o1;
            Window window2 = (Window)o2;
            String order1 = window1.getDeclaredProperty("theme.order");
            String order2 = window2.getDeclaredProperty("theme.order");
            return ThemeTools.compareWindowOrder((String)order1, (String)window1.getName(), (String)order2, (String)window2.getName());
        }
    };

    public MoveWindowCommand(PortalObjectId windowId, int fromPos, String fromRegion, int toPos, String toRegion) throws IllegalArgumentException {
        super(windowId);
        this.fromPos = fromPos;
        this.fromRegion = fromRegion;
        this.toPos = toPos;
        this.toRegion = toRegion;
    }

    public CommandInfo getInfo() {
        return info;
    }

    public ControllerResponse execute() throws ControllerException {
        if (this.isDashboard()) {
            ListMap blah = new ListMap(tmp);
            for (Window window : this.page.getChildren(8)) {
                String region;
                if (window == this.target || (region = window.getDeclaredProperty("theme.region")) == null) continue;
                blah.put((Object)region, (Object)window);
            }
            for (String string : blah.keySet()) {
                Window window;
                Iterator j;
                int order;
                boolean processFrom = string.equals(this.fromRegion);
                boolean processTo = string.equals(this.toRegion);
                if (!processFrom && !processTo) {
                    order = 0;
                    j = blah.iterator((Object)string);
                    while (j.hasNext()) {
                        window = (Window)j.next();
                        window.setDeclaredProperty("theme.order", Integer.toString(order++));
                    }
                    continue;
                }
                if (processFrom) {
                    order = 0;
                    j = blah.iterator((Object)string);
                    while (j.hasNext()) {
                        window = (Window)j.next();
                        if (window == this.target) {
                            --order;
                            continue;
                        }
                        window.setDeclaredProperty("theme.order", Integer.toString(order++));
                    }
                }
                if (!processTo) continue;
                order = 0;
                j = blah.iterator((Object)string);
                while (j.hasNext()) {
                    window = (Window)j.next();
                    if (order == this.toPos) {
                        // empty if block
                    }
                    int n = ++order;
                    ++order;
                    window.setDeclaredProperty("theme.order", Integer.toString(n));
                }
            }
            this.target.setDeclaredProperty("theme.region", this.toRegion);
            this.target.setDeclaredProperty("theme.order", Integer.toString(this.toPos));
        }
        return null;
    }
}

