/*
 * Decompiled with CFR 0.152.
 */
package com.osivia.cns.proto.workflows;

import com.osivia.cns.proto.constants.CnsConstants;
import fr.toutatice.ecm.platform.service.portalviews.adapter.WidgetsAdapterService;
import fr.toutatice.ecm.workflows.integration.beans.IntegrationRoutingTaskActionsBean;
import fr.toutatice.ecm.workflows.integration.constants.WorkflowsConstants;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="routingTaskActions")
@Install(precedence=132)
public class CnsRoutingTaskActionsBean
extends IntegrationRoutingTaskActionsBean {
    private static final long serialVersionUID = -4585041875109709783L;

    public String endTask(Task task) throws ClientException {
        String view = "view_documents";
        String wfName = super.getCurrentWorkflowName(task);
        if (WorkflowsConstants.VALIDATION_WORKFLOWS.contains(wfName) || "cns-validation".equals(wfName)) {
            String clickedButton = this.getClickedButton();
            if (((String)WorkflowsConstants.CONTINUE_VALIDATION_ACTIONS.get(0)).equals(clickedButton) || "direct-validation".equals(clickedButton)) {
                this.saveMetaData(task);
            }
            view = super.endTask(task);
            WidgetsAdapterService aSrv = (WidgetsAdapterService)Framework.getService(WidgetsAdapterService.class);
            if (aSrv.isInPortalViewContext() && ("direct-validation".equals(clickedButton) || "cancel".equals(clickedButton))) {
                view = "action_done";
            }
        } else {
            view = super.endTask(task);
        }
        return view;
    }

    private void saveMetaData(Task task) {
        Map formVariables = this.getFormVariables(task);
        String docId = (String)task.getTargetDocumentsIds().get(0);
        DocumentModel document = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
        Set<Map.Entry<String, String>> metaDataSet = CnsConstants.METADATA.entrySet();
        for (Map.Entry<String, String> metaData : metaDataSet) {
            document.setPropertyValue(metaData.getValue(), (Serializable)formVariables.get(metaData.getKey()));
        }
        this.documentManager.saveDocument(document);
    }

    public boolean isTaskFormRequired() {
        String clikedButton = this.getClickedButton();
        return ((String)WorkflowsConstants.CONTINUE_VALIDATION_ACTIONS.get(0)).equals(clikedButton) || "direct-validation".equals(clikedButton);
    }
}

