/*
 * Decompiled with CFR 0.152.
 */
package com.osivia.cns.proto.listeners;

import com.osivia.cns.proto.constants.CnsConstants;
import fr.toutatice.ecm.workflows.integration.constants.WorkflowsConstants;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.routing.web.RoutingTaskActionsBean;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;

public class CnsFillMetadaTaskListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        CoreSession session = ctx.getCoreSession();
        String eventName = event.getName();
        if (event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            DocumentModel document = docCtx.getSourceDocument();
            if ("beforeDocumentModification".equals(eventName) && "TaskDoc".equals(document.getType())) {
                Task task = (Task)document.getAdapter(Task.class);
                String taskName = task.getName();
                Map<String, Serializable> formVariables = this.getFormVariables(task);
                if (WorkflowsConstants.CHOOSE_PARTICIPANTS_TASKS.contains(taskName) || "direct-validation-task".equals(taskName)) {
                    String docId = (String)task.getTargetDocumentsIds().get(0);
                    DocumentModel currentDoc = session.getDocument((DocumentRef)new IdRef(docId));
                    Set<Map.Entry<String, String>> metaDataSet = CnsConstants.METADATA.entrySet();
                    for (Map.Entry<String, String> metaData : metaDataSet) {
                        formVariables.put(metaData.getKey(), currentDoc.getPropertyValue(metaData.getValue()));
                    }
                    this.fillFormVariables(session, task, formVariables);
                }
            }
        }
    }

    private Map<String, Serializable> getFormVariables(Task task) {
        RoutingTaskActionsBean rtActions = (RoutingTaskActionsBean)SeamComponentCallHelper.getSeamComponentByName((String)"routingTaskActions");
        Map formVariables = rtActions.getFormVariables(task);
        return formVariables;
    }

    private void fillFormVariables(CoreSession session, Task task, Map<String, Serializable> formVariables) {
        this.getGraphNode(session, task).setVariables(formVariables);
    }

    private GraphNode getGraphNode(CoreSession session, Task task) {
        String routeDocId = task.getVariable("routeInstanceDocId");
        String nodeId = task.getVariable("nodeId");
        DocumentModel doc = session.getDocument((DocumentRef)new IdRef(routeDocId));
        GraphRoute route = (GraphRoute)doc.getAdapter(GraphRoute.class);
        GraphNode node = route.getNode(nodeId);
        return node;
    }
}

