/*
 * Decompiled with CFR 0.152.
 */
package com.osivia.cns.proto.massvalidation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeOperationHelper;
import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.runtime.api.Framework;

public class MassValidationListener
implements PostCommitEventListener {
    public static final String WITH_VALIDATION = "withValidation";
    private static final Log log = LogFactory.getLog(MassValidationListener.class);

    public void handleEvent(EventBundle events) throws ClientException {
        for (Event event : events) {
            EventContext ctx = event.getContext();
            if (!(ctx instanceof DocumentEventContext)) {
                return;
            }
            DocumentModel doc = ((DocumentEventContext)ctx).getSourceDocument();
            if (doc == null) {
                return;
            }
            log.info((Object)"Application des metadonn\u00e9es");
            HashMap propertiesToChange = new HashMap();
            for (Map.Entry property : ctx.getProperties().entrySet()) {
                if (!((String)property.getKey()).contains(":") || property.getValue() == null) continue;
                if (property.getValue() instanceof String) {
                    if (StringUtils.isNotBlank((String)((Serializable)property.getValue()).toString())) {
                        propertiesToChange.put(property.getKey(), ((Serializable)property.getValue()).toString());
                    }
                } else {
                    propertiesToChange.put(property.getKey(), (String)property.getValue());
                }
                log.info((Object)((String)property.getKey() + "->" + property.getValue()));
            }
            CoreSession coreSession = ctx.getCoreSession();
            DocumentModelList listToCheck = coreSession.query("SELECT * FROM Document WHERE ecm:path STARTSWITH '" + doc.getPathAsString() + "' AND ecm:mixinType <> 'folderish' " + " AND ecm:currentLifeCycleState = 'project' AND ecm:isVersion = 0");
            ArrayList<DocumentModel> listToSave = new ArrayList<DocumentModel>();
            DocumentRoutingService routingService = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
            for (DocumentModel child : listToCheck) {
                try {
                    List routes = routingService.getDocumentRoutesForAttachedDocument(coreSession, child.getId());
                    if (routes.size() != 0) continue;
                    for (Map.Entry property : propertiesToChange.entrySet()) {
                        child.setPropertyValue((String)property.getKey(), (Serializable)property.getValue());
                    }
                    log.info((Object)("Traitement de " + child.getPathAsString()));
                    listToSave.add(child);
                }
                catch (PropertyNotFoundException pnfe) {
                    log.error((Object)("Traitement de " + child.getPathAsString() + " " + pnfe.getMessage()));
                }
            }
            DocumentModel[] t = new DocumentModel[listToSave.size()];
            coreSession.saveDocuments(listToSave.toArray(t));
            if (!ctx.getProperty(WITH_VALIDATION).equals(Boolean.TRUE)) continue;
            log.info((Object)"Validation en masse");
            for (DocumentModel docToSave : listToSave) {
                try {
                    ToutaticeOperationHelper.runOperationChain((CoreSession)docToSave.getCoreSession(), (String)"validateDocument", (Object)docToSave);
                }
                catch (ToutaticeException e) {
                    log.error((Object)("Traitement de " + docToSave.getPathAsString() + " " + e.getMessage()));
                }
            }
        }
    }
}

