package org.osivia.portal.services.inscription;

import java.util.regex.Matcher;

import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
public class InfosFormValidator implements Validator {

    private static String ATOM = "[a-z0-9!#$%&'*+/=?^_`{|}~-]";
    private static String DOMAIN = "(" + ATOM + "+(\\." + ATOM + "+)*";
    private static String IP_DOMAIN = "\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]";

    private java.util.regex.Pattern pattern = java.util.regex.Pattern.compile("^" + ATOM + "+(\\." + ATOM + "+)*@" + DOMAIN + "|" + IP_DOMAIN + ")$",
            java.util.regex.Pattern.CASE_INSENSITIVE);

    @Override
    public boolean supports(Class<?> clazz) {

        return InfosForm.class.isAssignableFrom(clazz);
    }

    @Override
    public void validate(Object target, Errors errors) {
        InfosForm infosForm = (InfosForm) target;

        ValidationUtils.rejectIfEmpty(errors, "nom", "empty");
        ValidationUtils.rejectIfEmpty(errors, "prenom", "empty");
        ValidationUtils.rejectIfEmpty(errors, "mail", "empty");
        ValidationUtils.rejectIfEmpty(errors, "societe", "empty");

        Matcher m = pattern.matcher(infosForm.getMail());
        if(!m.matches()) {
            errors.rejectValue("mail", "badaddress");
        }
    }


}
