/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.inscription;

import com.sun.mail.smtp.SMTPTransport;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.validation.Valid;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.services.inscription.DemandeInfosFormFormatter;
import org.osivia.portal.services.inscription.InfosForm;
import org.osivia.portal.services.inscription.InfosFormValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"infosForm"})
public class DemandeInfosControleur
extends GenericPortlet
implements PortletContextAware,
PortletConfigAware {
    public static final Logger log = Logger.getLogger(DemandeInfosControleur.class.getSimpleName());
    private PortletContext portletContext;
    private PortletConfig portletConfig;
    @Autowired
    private InfosFormValidator infosFormValidator;

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)this.infosFormValidator);
    }

    @ActionMapping
    public void envoiMail(@Valid InfosForm infosForm, BindingResult result, ActionRequest request, ActionResponse response, PortletSession session, ModelMap modelMap) {
        if (!result.hasErrors()) {
            Properties props = System.getProperties();
            Session mailSession = Session.getInstance((Properties)props, null);
            MimeMessage msg = new MimeMessage(mailSession);
            try {
                msg.setFrom((Address)new InternetAddress(infosForm.getMail()));
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                String mailDestinataire = window.getProperty("inscription.contact.destinataire");
                msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)mailDestinataire, (boolean)false));
                msg.setSubject("Demande de cr\u00e9ation de compte", "UTF-8");
                MimeMultipart mp = new MimeMultipart();
                MimeBodyPart htmlPart = new MimeBodyPart();
                htmlPart.setContent((Object)DemandeInfosFormFormatter.format((InfosForm)infosForm), "text/html; charset=UTF-8");
                mp.addBodyPart((BodyPart)htmlPart);
                msg.setContent((Multipart)mp);
                msg.setSentDate(new Date());
                SMTPTransport t = (SMTPTransport)mailSession.getTransport("smtp");
                t.connect("localhost", "contact", "");
                t.sendMessage((Message)msg, msg.getAllRecipients());
                t.close();
            }
            catch (AddressException e) {
                log.info(e.getMessage());
            }
            catch (MessagingException e) {
                log.info(e.getMessage());
            }
            response.setRenderParameter("action", "mailok");
        }
    }

    @RenderMapping
    public String view(RenderRequest request, ModelMap model) {
        InfosForm infosForm = (InfosForm)model.get((Object)"infosForm");
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String mailDestinataire = window.getProperty("inscription.contact.destinataire");
        if (mailDestinataire == null || mailDestinataire.length() == 0) {
            return "no-conf";
        }
        return "list";
    }

    @RenderMapping(params={"action=mailok"})
    public String mailok(RenderRequest request, ModelMap model) {
        return "mailok";
    }

    @ModelAttribute
    private InfosForm loadModel() {
        return new InfosForm();
    }
}

