/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.event.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletException;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.services.calendar.event.portlet.model.EventVO;
import org.osivia.services.calendar.event.portlet.service.IEventService;
import org.osivia.services.calendar.event.portlet.utils.IEvent;
import org.springframework.stereotype.Service;

@Service
public class EventServiceImpl
implements IEventService {
    private static final String DESCRIPTION_PROPERTY = "dc:description";
    private static final String END_DATE_PROPERTY = "vevent:dtend";
    private static final String START_DATE_PROPERTY = "vevent:dtstart";
    private static final String LOCATION_PROPERTY = "vevent:location";

    public IEvent getEvent(NuxeoController nuxeoController, String id) throws PortletException {
        Document eventDoc = nuxeoController.fetchDocument(id);
        if (eventDoc == null) {
            throw new PortletException("No event found with id: " + id);
        }
        nuxeoController.setCurrentDoc(eventDoc);
        nuxeoController.insertContentMenuBarItems();
        return this.fillEventModel(nuxeoController, eventDoc);
    }

    private IEvent fillEventModel(NuxeoController nuxeoController, Document doc) {
        Locale locale = nuxeoController.getRequest().getLocale();
        DateFormat dateFormat = SimpleDateFormat.getDateInstance(2, locale);
        DateFormat timeFormat = SimpleDateFormat.getTimeInstance(3, locale);
        EventVO event = new EventVO();
        String title = doc.getTitle();
        event.setTitle(title);
        String description = doc.getString(DESCRIPTION_PROPERTY);
        event.setDescription(description);
        Date startDate = doc.getDate(START_DATE_PROPERTY);
        event.setStartDate(dateFormat.format(startDate) + "  " + timeFormat.format(startDate));
        Date endDate = doc.getDate(END_DATE_PROPERTY);
        event.setEndDate(dateFormat.format(endDate) + "  " + timeFormat.format(endDate));
        String location = doc.getString(LOCATION_PROPERTY);
        event.setLocation(location);
        return event;
    }
}

