/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import java.util.Date;
import org.apache.commons.lang.time.DateFormatUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class ListEventsCommand
implements INuxeoCommand {
    private NuxeoQueryFilterContext queryContext;
    private final String contextPath;
    private final Date startDate;
    private final Date endDate;

    public ListEventsCommand(NuxeoQueryFilterContext queryContext, String contextPath, Date startDate, Date endDate) {
        this.queryContext = queryContext;
        this.contextPath = contextPath;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        String start = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(this.startDate);
        String end = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(this.endDate);
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:mixinType = 'Schedulable' ");
        clause.append("AND ecm:path STARTSWITH '").append(this.contextPath).append("' ");
        clause.append("AND (vevent:dtstart < TIMESTAMP '").append(end).append("') ");
        clause.append("AND (vevent:dtend > TIMESTAMP '").append(start).append("') ");
        clause.append("ORDER BY vevent:dtstart");
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)this.queryContext, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.Query");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest));
        request.setHeader("X-NXDocumentProperties", "*");
        return request.execute();
    }

    public String getId() {
        return "Calendar/" + this.contextPath;
    }
}

