/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.portlet.service.generator;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.portlet.PortletException;
import org.apache.commons.lang.time.DateUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.services.calendar.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.portlet.model.calendar.DailyCalendarData;
import org.osivia.services.calendar.portlet.model.events.DailyCalendarEventsData;
import org.osivia.services.calendar.portlet.model.events.DailyEvent;
import org.osivia.services.calendar.portlet.model.events.Event;
import org.osivia.services.calendar.portlet.model.events.EventsData;
import org.osivia.services.calendar.portlet.model.events.TimeSlotEvent;
import org.osivia.services.calendar.portlet.service.ICalendarCollisionManager;
import org.osivia.services.calendar.portlet.service.generator.CalendarGeneratorImpl;
import org.osivia.services.calendar.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dailyCalendarGenerator")
public class DailyCalendarGeneratorImpl
extends CalendarGeneratorImpl {
    @Autowired
    private ICalendarCollisionManager collisionManager;

    public PeriodTypes getPeriodType() throws PortletException {
        return PeriodTypes.DAY;
    }

    protected CalendarData generateSpecializedCalendarData(PortalControllerContext portalControllerContext) throws PortletException {
        DailyCalendarData calendarData = new DailyCalendarData();
        Date selectedDate = this.getSelectedDate(portalControllerContext);
        calendarData.setHeader(this.getHeader(portalControllerContext, selectedDate));
        int position = 280;
        calendarData.setAutoScroll(String.valueOf(position));
        return calendarData;
    }

    protected void updateSpecializedCalendarData(PortalControllerContext portalControllerContext, CalendarData calendarData) {
        DailyCalendarData dailyCalendarData = (DailyCalendarData)calendarData;
        Date selectedDate = calendarData.getSelectedDate();
        dailyCalendarData.setHeader(this.getHeader(portalControllerContext, selectedDate));
    }

    private String getHeader(PortalControllerContext portalControllerContext, Date selectedDate) {
        Locale locale = portalControllerContext.getRequest().getLocale();
        DateFormat dateFormat = DateFormat.getDateInstance(0, locale);
        return dateFormat.format(selectedDate);
    }

    protected String getDisplayDate(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        DateFormat dateFormat = DateFormat.getDateInstance(2, portalControllerContext.getRequest().getLocale());
        return dateFormat.format(calendarData.getSelectedDate());
    }

    protected EventsData generateSpecializedEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData, List<Event> events) throws PortletException {
        Locale locale = portalControllerContext.getRequest().getLocale();
        Bundle bundle = this.getBundleFactory().getBundle(locale);
        DateFormat timeFormat = DateFormat.getTimeInstance(3, locale);
        Date selectedDate = calendarData.getSelectedDate();
        Calendar startCalendar = GregorianCalendar.getInstance(locale);
        Calendar endCalendar = GregorianCalendar.getInstance(locale);
        ArrayList<TimeSlotEvent> dailyEvents = new ArrayList<TimeSlotEvent>(events.size());
        TreeMap<String, ArrayList<DailyEvent>> fullDayEvents = new TreeMap<String, ArrayList<DailyEvent>>();
        for (Event event : events) {
            DailyEvent dailyEvent;
            startCalendar.setTime(event.getStartDate());
            endCalendar.setTime(event.getEndDate());
            boolean begin = DateUtils.isSameDay((Date)selectedDate, (Date)event.getStartDate());
            boolean end = DateUtils.isSameDay((Date)selectedDate, (Date)event.getEndDate());
            StringBuilder builder = new StringBuilder();
            if (begin || end) {
                if (begin) {
                    builder.append(timeFormat.format(event.getStartDate()));
                    if (end) {
                        builder.append(" - ");
                    }
                }
                if (end) {
                    builder.append(timeFormat.format(event.getEndDate()));
                }
            } else {
                builder.append(bundle.getString("CALENDAR_EVENT_ALL_DAY"));
            }
            String time = builder.toString();
            if (begin && end) {
                String top;
                TimeSlotEvent timeSlotEvent = new TimeSlotEvent(event, selectedDate);
                dailyEvent = timeSlotEvent;
                if (begin) {
                    builder = new StringBuilder();
                    builder.append((float)DateUtils.getFragmentInMilliseconds((Calendar)startCalendar, (int)5) / Float.valueOf(3600000.0f).floatValue() * 40.0f);
                    builder.append("px");
                    top = builder.toString();
                } else {
                    top = "0";
                }
                timeSlotEvent.setTop(top);
                builder = new StringBuilder();
                builder.append(this.getEventHours(startCalendar, endCalendar, begin, end) * 40.0f);
                builder.append("px");
                timeSlotEvent.setHeight(builder.toString());
                timeSlotEvent.setStartTime(event.getStartDate().getTime());
                timeSlotEvent.setEndTime(event.getEndDate().getTime());
                dailyEvents.add(timeSlotEvent);
            } else {
                dailyEvent = new DailyEvent(event, selectedDate);
                ArrayList<DailyEvent> fullDayEventsList = (ArrayList<DailyEvent>)fullDayEvents.get("");
                if (fullDayEventsList == null) {
                    fullDayEventsList = new ArrayList<DailyEvent>();
                    fullDayEvents.put("", fullDayEventsList);
                }
                fullDayEventsList.add(dailyEvent);
            }
            dailyEvent.setBegin(begin);
            dailyEvent.setEnd(end);
            dailyEvent.setTime(time);
        }
        this.collisionManager.updateDailyEvents(portalControllerContext, dailyEvents, selectedDate);
        DailyCalendarEventsData eventsData = new DailyCalendarEventsData();
        eventsData.setEvents(dailyEvents);
        eventsData.setMappedEvents(fullDayEvents);
        return eventsData;
    }
}

