<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form"%>
<%@ taglib uri="internationalization" prefix="is"%>

<%@ page contentType="text/html" isELIgnored="false"%>


<portlet:defineObjects />

<portlet:actionURL name="save" var="saveActionURL" />


<div class="container">
    <form:form name="save" modelAttribute="configuration" action="${saveActionURL}" method="post" class="form-horizontal" role="form">
        <!-- CMS path -->
        <c:set var="cmsPathLabel">
            <is:getProperty key="CALENDAR_CMS_PATH" />
        </c:set>
        <div class="form-group">
            <form:label path="cmsPath" class="control-label col-sm-4">${cmsPathLabel}</form:label>
            <div class="col-sm-8">
                <form:input path="cmsPath" class="form-control" placeholder="${cmsPathLabel}" />
            </div>
        </div>
        
        <!-- Default view -->
        <c:set var="defaultViewLabel">
            <is:getProperty key="CALENDAR_DEFAULT_VIEW" />
        </c:set>
        <div class="form-group">
            <form:label path="periodTypeName" class="control-label col-sm-4">${defaultViewLabel}</form:label>
            <div class="col-sm-8">
                <form:select path="periodTypeName" class="form-control">
                    <form:option value=""></form:option>
                    <c:forEach var="periodType" items="${periodTypes}">
                        <form:option value="${periodType.key}">${periodType.value}</form:option>
                    </c:forEach>
                </form:select>
            </div>
        </div>
        
        <!-- Compact view -->
        <div class="form-group">
            <form:label path="compactView" class="control-label col-sm-4"><is:getProperty key="CALENDAR_COMPACT_VIEW" /></form:label>
            <div class="col-sm-8">
                <div class="checkbox">
                    <label>
                        <form:checkbox path="compactView" />
                    </label>
                </div>
                <span class="help-block"><is:getProperty key="CALENDAR_COMPACT_VIEW_HELP" /></span>
            </div>
        </div>
        
        <!-- Buttons -->
        <div class="form-group">
            <div class="col-sm-offset-4 col-sm-8">
                <input type="submit" class="btn btn-default btn-primary" value='<is:getProperty key="SAVE" />' />
                <button type="button" class="btn btn-default" onclick="closeFancybox()"><is:getProperty key="CANCEL" /></button>
            </div>
        </div>
    </form:form>
</div>
