<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="internationalization" prefix="is"%>

<%@ page contentType="text/html" isELIgnored="false"%>


<portlet:defineObjects />


<div class="calendar monthly-calendar">
    <!-- Toolbar -->
    <jsp:include page="calendar-toolbar.jsp" />
    
    <!-- Month -->
    <table class="table table-bordered">
        <!-- Header -->
        <thead>
            <tr>
                <c:forEach var="calendarHeader" items="${calendarData.headers}">
                    <th class="text-center">
                        <div>
                            <span>${calendarHeader}</span>
                        </div>
                    </th>
                </c:forEach>
            </tr>
        </thead>
        
        <!-- Body -->
        <tbody>
            <c:forEach var="week" items="${calendarData.weeks}">
                <tr>
                    <c:forEach var="day" items="${week.days}" varStatus="dayStatus">
                        <c:set var="key" value="${week.name}:${day.name}" />
                    
                        <c:remove var="otherMonthClass" />
                        <c:if test="${not day.currentMonth}">
                            <c:set var="otherMonthClass" value="text-muted" />
                        </c:if>
                    
                        <td class="${otherMonthClass}">
                            <div>
                                <div class="text-right clearfix">
                                    <span>${day.name}</span>
                                    <span class="hidden-xs">${day.monthDisplay}</span>
                                    
                                    <c:if test="${dayStatus.first}">
                                        <span class="label label-default pull-left hidden-xs">${week.name}</span>
                                    </c:if>
                                </div>
                                
                                <div class="clearfix">
                                    <c:forEach var="event" items="${eventsData.mappedEvents[key]}" varStatus="eventStatus">
                                        <c:remove var="eventClass" />
                                        <c:if test="${not event.begin}">
                                            <c:set var="eventClass" value="has-previous" />
                                        </c:if>
                                        <c:if test="${not event.end}">
                                            <c:set var="eventClass" value="has-next ${eventClass}" />
                                        </c:if>
                                    
                                        <div class="event bg-primary ${eventClass}">
                                            <a href="${event.viewURL}" class="no-ajax-link">
                                                <span>${event.time}</span>
                                                <span>${event.title}</span>
                                            </a>
                                        </div>
                                    </c:forEach>
                                    
                                    <c:if test="${fn:length(eventsData.mappedEvents[key]) > 2}">
                                        <div class="hidden-xs">
                                            <i class="glyphicons more"></i>
                                        </div>
                                    </c:if>
                                </div>
                            </div>
                        </td>
                    </c:forEach>
                </tr>
            </c:forEach>
        </tbody>
    </table>
</div>
