/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.view.portlet.service.generator;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.portlet.PortletException;
import org.apache.commons.lang.time.DateUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.model.events.EventsData;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepository;
import org.osivia.services.calendar.view.portlet.service.CalendarViewService;
import org.osivia.services.calendar.view.portlet.service.generator.ICalendarGenerator;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CalendarGeneratorImpl
implements ICalendarGenerator {
    protected static final int PLANNING_COMPACT_MAX = 5;
    @Autowired
    private CalendarViewRepository calendarRepository;
    private final IBundleFactory bundleFactory;
    protected PeriodTypes periodType;

    public CalendarGeneratorImpl() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public PeriodTypes getPeriodType() throws PortletException {
        return this.periodType;
    }

    public void setPeriodType(PeriodTypes period) throws PortletException {
        this.periodType = period;
    }

    public CalendarData generateCalendarData(PortalControllerContext portalControllerContext, PeriodTypes periodType) throws PortletException {
        CalendarData calendarData = new CalendarData();
        calendarData.setPeriodType(periodType);
        calendarData.setGenerator((ICalendarGenerator)this);
        this.fillCalendarDates(portalControllerContext, calendarData, null);
        return calendarData;
    }

    public void updateCalendarData(PortalControllerContext portalControllerContext, CalendarData calendarData, Date selectedDate) throws PortletException {
        this.fillCalendarDates(portalControllerContext, calendarData, selectedDate);
    }

    private void fillCalendarDates(PortalControllerContext portalControllerContext, CalendarData calendarData, Date forcedSelectedDate) throws PortletException {
        PeriodTypes periodType = calendarData.getPeriodType();
        Date selectedDate = forcedSelectedDate;
        if (selectedDate == null) {
            selectedDate = this.getSelectedDate(portalControllerContext, periodType);
        }
        calendarData.setSelectedDate(selectedDate);
        Date startDate = this.getStartDate(portalControllerContext, periodType, selectedDate);
        calendarData.setStartDate(startDate);
    }

    protected Date getSelectedDate(PortalControllerContext portalControllerContext, PeriodTypes periodType) {
        Date selectedDate;
        if (PeriodTypes.PLANNING.equals((Object)periodType)) {
            selectedDate = new Date();
        } else {
            String parameter = portalControllerContext.getRequest().getParameter("date");
            if (parameter == null) {
                selectedDate = new Date();
            } else {
                try {
                    selectedDate = CalendarViewService.SELECTED_DATE_FORMAT.parse(parameter);
                }
                catch (ParseException e) {
                    selectedDate = new Date();
                }
            }
        }
        return DateUtils.truncate((Date)selectedDate, (int)5);
    }

    protected Date getStartDate(PortalControllerContext portalControllerContext, PeriodTypes periodType, Date selectedDate) {
        Calendar calendar = GregorianCalendar.getInstance(portalControllerContext.getRequest().getLocale());
        calendar.setTime(selectedDate);
        if (!PeriodTypes.PLANNING.equals((Object)periodType)) {
            calendar.set(7, calendar.getFirstDayOfWeek());
        }
        return calendar.getTime();
    }

    protected Date getEndDate(PortalControllerContext portalControllerContext, PeriodTypes periodType, Date selectedDate, Date startDate) {
        Date endDate;
        if (PeriodTypes.PLANNING.equals((Object)periodType)) {
            endDate = null;
        } else {
            Calendar calendar = GregorianCalendar.getInstance(portalControllerContext.getRequest().getLocale());
            calendar.setTime(startDate);
            calendar.add(periodType.getField(), 1);
            calendar.add(14, -1);
            endDate = calendar.getTime();
        }
        return endDate;
    }

    public EventsData generateEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        List events = this.calendarRepository.getEvents(portalControllerContext, calendarData.getStartDate(), calendarData.getEndDate());
        EventsData eventsData = events == null ? null : this.generateSpecializedEventsData(portalControllerContext, calendarData, events);
        return eventsData;
    }

    protected abstract EventsData generateSpecializedEventsData(PortalControllerContext var1, CalendarData var2, List<Event> var3) throws PortletException;

    public IBundleFactory getBundleFactory() {
        return this.bundleFactory;
    }
}

