/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.event.edition.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.PortletException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.time.DateUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.common.model.Attachment;
import org.osivia.services.calendar.common.model.Attachments;
import org.osivia.services.calendar.common.model.CalendarCommonEventForm;
import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.osivia.services.calendar.common.model.CalendarEventDates;
import org.osivia.services.calendar.common.repository.CalendarRepositoryImpl;
import org.osivia.services.calendar.event.edition.portlet.repository.CalendarEventEditionRepository;
import org.osivia.services.calendar.event.edition.portlet.repository.command.CalendarEventCreationCommand;
import org.osivia.services.calendar.event.edition.portlet.repository.command.CalendarEventEditionCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class CalendarEventEditionRepositoryImpl
extends CalendarRepositoryImpl
implements CalendarEventEditionRepository {
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    private DocumentDAO dao;
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private final DateFormat timeFormat = new SimpleDateFormat("HH:mm");
    private final int halfHour = Long.valueOf(TimeUnit.HOURS.toMinutes(1L) / 2L).intValue();

    @Override
    public boolean isAllDay(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        boolean allDay = document == null ? false : BooleanUtils.toBoolean((Boolean)document.getProperties().getBoolean("vevent:allDay"));
        return allDay;
    }

    @Override
    public CalendarEventDates getDates(PortalControllerContext portalControllerContext, Document document, boolean allDay) throws PortletException {
        Date endDate;
        Date startDate;
        CalendarEventDates dates = (CalendarEventDates)this.applicationContext.getBean(CalendarEventDates.class);
        if (document == null) {
            startDate = null;
            endDate = null;
        } else {
            startDate = document.getDate("vevent:dtstart");
            endDate = document.getDate("vevent:dtend");
        }
        if (startDate == null) {
            Date currentDate = new Date();
            startDate = DateUtils.truncate((Date)currentDate, (int)10);
            startDate = DateUtils.toCalendar((Date)currentDate).get(12) > this.halfHour ? DateUtils.addHours((Date)startDate, (int)1) : DateUtils.addMinutes((Date)startDate, (int)this.halfHour);
        }
        if (endDate == null) {
            endDate = DateUtils.addHours((Date)startDate, (int)1);
        }
        if (allDay) {
            startDate = DateUtils.truncate((Date)startDate, (int)5);
            endDate = DateUtils.truncate((Date)endDate, (int)5);
            endDate = DateUtils.addDays((Date)endDate, (int)-1);
        }
        dates.setStartDate(this.dateFormat.format(startDate));
        dates.setStartTime(this.timeFormat.format(startDate));
        dates.setEndDate(this.dateFormat.format(endDate));
        dates.setEndTime(this.timeFormat.format(endDate));
        return dates;
    }

    @Override
    public String getLocation(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        String location = document == null ? null : document.getString("vevent:location");
        return location;
    }

    @Override
    public String getDescription(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        String description = document == null ? null : document.getString("note:note");
        return description;
    }

    @Override
    public Attachments getAttachments(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        PropertyList propertyList;
        Attachments attachments = (Attachments)this.applicationContext.getBean(Attachments.class);
        if (document != null && document.getProperties() != null && (propertyList = document.getProperties().getList("files:files")) != null && !propertyList.isEmpty()) {
            List<Attachment> files = attachments.getFiles();
            if (files == null) {
                files = new ArrayList<Attachment>();
                attachments.setFiles(files);
            }
            for (int i = 0; i < propertyList.size(); ++i) {
                MimeType mimeType;
                PropertyMap attachmentMap = propertyList.getMap(i);
                PropertyMap attachmentFileMap = attachmentMap.getMap("file");
                String fileName = attachmentFileMap.getString("name");
                try {
                    mimeType = new MimeType(attachmentFileMap.getString("mime-type"));
                }
                catch (MimeTypeParseException e) {
                    mimeType = null;
                }
                Attachment file = (Attachment)this.applicationContext.getBean(Attachment.class);
                file.setIndex(i);
                file.setTemporaryFileName(fileName);
                file.setTemporaryMimeType(mimeType);
                file.setIcon(this.dao.getIcon(mimeType));
                files.add(file);
            }
        }
        return attachments;
    }

    @Override
    public void save(PortalControllerContext portalControllerContext, CalendarEditionOptions options, CalendarCommonEventForm form) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = options.isCreation() ? (INuxeoCommand)this.applicationContext.getBean(CalendarEventCreationCommand.class, new Object[]{options, form}) : (INuxeoCommand)this.applicationContext.getBean(CalendarEventEditionCommand.class, new Object[]{options, form});
        nuxeoController.executeNuxeoCommand(command);
    }
}

