/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.plugin;

import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.Plugin;
import org.osivia.portal.api.taskbar.TaskbarFactory;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.services.calendar.plugin.CalendarPlayer;
import org.osivia.services.calendar.plugin.menubar.CalendarMenubarModule;

@Plugin(value="calendar.plugin")
public class CalendarPlugin
extends AbstractPluginPortlet {
    private static final String PLUGIN_NAME = "calendar.plugin";

    protected void customizeCMSProperties(CustomizationContext context) {
        this.customizeDocumentTypes(context);
        this.customizePlayers(context);
        this.customizeTaskbarItems(context);
        this.customizeMenubarModules(context);
    }

    protected void customizeDocumentTypes(CustomizationContext context) {
        Map types = this.getDocTypes(context);
        DocumentType event = DocumentType.createNode((String)"VEVENT");
        event.setIcon("glyphicons glyphicons-important-day");
        event.setForceContextualization(true);
        event.setEditable(true);
        types.put(event.getName(), event);
        DocumentType calendar = DocumentType.createNode((String)"Agenda");
        calendar.addSubtypes(new String[]{event.getName()});
        calendar.setIcon("glyphicons glyphicons-calendar");
        calendar.setBrowsable(false);
        calendar.setForceContextualization(true);
        calendar.setEditable(true);
        types.put(calendar.getName(), calendar);
    }

    protected void customizePlayers(CustomizationContext context) {
        PortletContext portletContext = this.getPortletContext();
        List players = this.getPlayers(context);
        CalendarPlayer calendar = new CalendarPlayer(portletContext);
        players.add(calendar);
    }

    private void customizeTaskbarItems(CustomizationContext context) {
        TaskbarItems items = this.getTaskbarItems(context);
        TaskbarFactory factory = this.getTaskbarService().getFactory();
        TaskbarItem calendar = factory.createCmsTaskbarItem("CALENDAR", "CALENDAR_TASK", "glyphicons glyphicons-calendar", "Agenda");
        factory.preset(calendar, true, Integer.valueOf(3));
        items.add(calendar);
    }

    protected void customizeMenubarModules(CustomizationContext context) {
        List modules = this.getMenubarModules(context);
        CalendarMenubarModule calendar = new CalendarMenubarModule();
        modules.add(calendar);
    }

    protected String getPluginName() {
        return PLUGIN_NAME;
    }
}

