/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.event.preview.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.util.Date;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.calendar.event.preview.portlet.model.CalendarEventPreviewForm;
import org.osivia.services.calendar.event.preview.portlet.repository.CalendarEventPreviewRepository;
import org.osivia.services.calendar.event.preview.portlet.service.CalendarEventPreviewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class CalendarEventPreviewServiceImpl
implements CalendarEventPreviewService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CalendarEventPreviewRepository repository;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;

    public CalendarEventPreviewForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        String pagePath;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String path = window.getProperty("osivia.event-preview.path");
        NuxeoDocumentContext documentContext = this.repository.getDocumentContext(portalControllerContext, path);
        Document document = documentContext.getDocument();
        String pageId = window.getProperty("osivia.event-preview.page-id");
        if (StringUtils.isEmpty((String)pageId)) {
            pagePath = null;
        } else {
            PortalObjectId pageObjectId = PortalObjectId.parse((String)pageId, (PortalObjectPath.Format)PortalObjectPath.SAFEST_FORMAT);
            pagePath = pageObjectId.toString(PortalObjectPath.CANONICAL_FORMAT);
        }
        CalendarEventPreviewForm form = (CalendarEventPreviewForm)this.applicationContext.getBean(CalendarEventPreviewForm.class);
        String title = document.getTitle();
        form.setTitle(title);
        boolean allDay = BooleanUtils.toBoolean((Boolean)document.getProperties().getBoolean("vevent:allDay"));
        form.setAllDay(allDay);
        Date startDate = document.getDate("vevent:dtstart");
        form.setStartDate(startDate);
        Date endDate = document.getDate("vevent:dtend");
        form.setEndDate(endDate);
        Date endDateAllDay = allDay ? DateUtils.addDays((Date)endDate, (int)-1) : null;
        form.setEndDateAllDay(endDateAllDay);
        boolean sameDay = allDay ? DateUtils.isSameDay((Date)startDate, (Date)endDateAllDay) : DateUtils.isSameDay((Date)startDate, (Date)endDate);
        form.setSameDay(sameDay);
        String location = document.getString("vevent:location");
        form.setLocation(location);
        String detailUrl = this.portalUrlFactory.getCMSUrl(portalControllerContext, pagePath, document.getPath(), null, null, null, null, null, null, null);
        form.setDetailUrl(detailUrl);
        if (documentContext.getPermissions().isEditable()) {
            // empty if block
        }
        return form;
    }
}

