/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.plugin.menubar;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.portlet.PortletException;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.PublicationInfos;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.urls.IPortalUrlFactory;

public class CalendarMenubarModule
implements MenubarModule {
    protected static final String CALENDAR_TYPE = "Agenda";
    protected static final String EVENT_TYPE = "VEVENT";
    protected static final String ID_EVENT_SOURCE_PROPERTY = "sync:idSource";
    protected static final String ADD_MENUBAR_ITEM_ID = "ADD";
    protected static final String ADD_CALENDAR_MENUBAR_ITEM_ID = "ADD_Agenda";
    protected static final String ADD_EVENT_MENUBAR_ITEM_ID = "ADD_VEVENT";
    protected static final String EDIT_MENUBAR_ITEM_ID = "EDIT";
    protected static final String DELETE_MENUBAR_ITEM_ID = "DELETE";
    private static final String REFRESH_MENUBAR_ITEM_ID = "REFRESH";
    protected static final String SYNCHRO_MENUBAR_ITEM_ID = "SYNCHRONIZED_CALENDAR";
    protected static final String CALENDAR_EDITION_PORTLET_INSTANCE = "osivia-services-calendar-edition-instance";
    protected static final String EVENT_EDITION_PORTLET_INSTANCE = "osivia-services-calendar-event-edition-instance";
    protected final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");

    public void customizeSpace(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext spaceDocumentContext) throws PortalException {
        boolean synchroPresent = false;
        MenubarItem refresh = null;
        for (MenubarItem menubarItem : menubar) {
            if (SYNCHRO_MENUBAR_ITEM_ID.equals(menubarItem.getId())) {
                synchroPresent = true;
            }
            if (REFRESH_MENUBAR_ITEM_ID.equals(menubarItem.getId())) {
                refresh = menubarItem;
            }
            if (!synchroPresent || refresh == null) continue;
            break;
        }
        if (synchroPresent && refresh != null) {
            menubar.remove(refresh);
        }
    }

    public void customizeDocument(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext documentContext) throws PortalException {
        if (documentContext != null) {
            DocumentType documentType = documentContext.getDocumentType();
            PublicationInfos publicationInfos = documentContext.getPublicationInfos();
            if (documentType != null && publicationInfos.isLiveSpace()) {
                Document document = (Document)documentContext.getDocument();
                MenubarItem addCalendar = null;
                MenubarItem addEvent = null;
                MenubarItem editCalendar = null;
                MenubarItem editEvent = null;
                for (MenubarItem menubarItem : menubar) {
                    if (ADD_CALENDAR_MENUBAR_ITEM_ID.equals(menubarItem.getId())) {
                        addCalendar = menubarItem;
                        continue;
                    }
                    if (ADD_EVENT_MENUBAR_ITEM_ID.equals(menubarItem.getId())) {
                        addEvent = menubarItem;
                        continue;
                    }
                    if (ADD_MENUBAR_ITEM_ID.equals(menubarItem.getId())) {
                        if (!CALENDAR_TYPE.equals(documentType.getName())) continue;
                        addEvent = menubarItem;
                        continue;
                    }
                    if (!EDIT_MENUBAR_ITEM_ID.equals(menubarItem.getId())) continue;
                    if (CALENDAR_TYPE.equals(documentType.getName())) {
                        editCalendar = menubarItem;
                        continue;
                    }
                    if (!EVENT_TYPE.equals(documentType.getName())) continue;
                    editEvent = menubarItem;
                }
                if (addCalendar != null) {
                    this.customizeMenubarItem(portalControllerContext, addCalendar, document, CALENDAR_TYPE, true);
                }
                if (addEvent != null) {
                    this.customizeMenubarItem(portalControllerContext, addEvent, document, EVENT_TYPE, true);
                }
                if (editCalendar != null) {
                    this.customizeMenubarItem(portalControllerContext, editCalendar, document, CALENDAR_TYPE, false);
                }
                if (editEvent != null) {
                    this.customizeMenubarItem(portalControllerContext, editEvent, document, EVENT_TYPE, false);
                }
                if (document.getString(ID_EVENT_SOURCE_PROPERTY) != null && !document.getString(ID_EVENT_SOURCE_PROPERTY).isEmpty()) {
                    try {
                        this.removeEditAndDelete(menubar, documentType, document, portalControllerContext);
                    }
                    catch (PortletException e) {
                        throw new PortalException((Exception)((Object)e));
                    }
                }
            }
        }
    }

    protected void customizeMenubarItem(PortalControllerContext portalControllerContext, MenubarItem item, Document document, String documentType, boolean creation) throws PortalException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.cms.uri", document.getPath());
        properties.put("theme.dyna.partial_refresh_enabled", String.valueOf(true));
        properties.put("osivia.ajaxLink", "1");
        properties.put("osivia.calendar.creation", String.valueOf(creation));
        String instance = CALENDAR_TYPE.equals(documentType) ? CALENDAR_EDITION_PORTLET_INSTANCE : (EVENT_TYPE.equals(documentType) ? EVENT_EDITION_PORTLET_INSTANCE : null);
        String url = instance == null ? null : this.portalUrlFactory.getStartPortletUrl(portalControllerContext, instance, properties);
        item.setUrl(url);
        item.setOnclick(null);
        item.setHtmlClasses(null);
    }

    public void removeEditAndDelete(List<MenubarItem> menubar, DocumentType documentType, Document document, PortalControllerContext portalControllerContext) throws PortletException {
        if (documentType != null && EVENT_TYPE.equals(documentType.getName())) {
            HashSet<MenubarItem> removedItems = new HashSet<MenubarItem>();
            for (MenubarItem menubarItem : menubar) {
                if (!EDIT_MENUBAR_ITEM_ID.equals(menubarItem.getId()) && !DELETE_MENUBAR_ITEM_ID.equals(menubarItem.getId())) continue;
                removedItems.add(menubarItem);
            }
            menubar.removeAll(removedItems);
        }
    }
}

