/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.view.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.calendar.view.portlet.model.CalendarEditionMode;
import org.osivia.services.calendar.view.portlet.model.CalendarViewForm;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class EventEditionCommand
implements INuxeoCommand {
    private static final String DOCUMENT_TYPE = "VEVENT";
    private final CalendarViewForm form;

    public EventEditionCommand(CalendarViewForm form) {
        this.form = form;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        CalendarEditionMode mode = this.form.getMode();
        Object document = CalendarEditionMode.CREATION.equals((Object)mode) ? this.create(nuxeoSession) : (CalendarEditionMode.EDITION.equals((Object)mode) ? this.edit(nuxeoSession) : null);
        return document;
    }

    public String getId() {
        return null;
    }

    private Document create(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        DocRef parent = new DocRef(this.form.getParentPath());
        PropertyMap properties = new PropertyMap();
        properties.set("vevent:dtend", this.form.getEndDate());
        properties.set("vevent:dtstart", this.form.getStartDate());
        properties.set("dc:title", this.form.getTitle());
        Document document = documentService.createDocument(parent, DOCUMENT_TYPE, null, properties, true);
        return document;
    }

    private Document edit(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        DocRef docRef = new DocRef(this.form.getDocId());
        PropertyMap map = new PropertyMap();
        map.set("vevent:dtend", this.form.getEndDate());
        map.set("vevent:dtstart", this.form.getStartDate());
        map.set("dc:title", this.form.getTitle());
        Document document = documentService.update(docRef, map, true);
        return document;
    }
}

