/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.event.edition.portlet.model.validation;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.services.calendar.common.model.CalendarCommonEventForm;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
public class CalendarEventEditionFormValidator
implements Validator {
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private final DateFormat timeFormat = new SimpleDateFormat("HH:mm");

    public boolean supports(Class<?> clazz) {
        return CalendarCommonEventForm.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        CalendarCommonEventForm form = (CalendarCommonEventForm)target;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"title", (String)"NotEmpty");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"dates.startDate", (String)"NotEmpty");
        if (StringUtils.isNotBlank((String)form.getDates().getStartDate())) {
            try {
                this.dateFormat.parse(form.getDates().getStartDate());
            }
            catch (ParseException e) {
                errors.rejectValue("dates.startDate", "Invalid");
            }
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"dates.endDate", (String)"NotEmpty");
        if (StringUtils.isNotBlank((String)form.getDates().getEndDate())) {
            try {
                this.dateFormat.parse(form.getDates().getEndDate());
            }
            catch (ParseException e) {
                errors.rejectValue("dates.endDate", "Invalid");
            }
        }
        if (BooleanUtils.isNotTrue((Boolean)form.isAllDay())) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"dates.startTime", (String)"NotEmpty");
            if (StringUtils.isNotBlank((String)form.getDates().getEndDate())) {
                try {
                    this.timeFormat.parse(form.getDates().getStartTime());
                }
                catch (ParseException e) {
                    errors.rejectValue("dates.startTime", "Invalid");
                }
            }
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"dates.endTime", (String)"NotEmpty");
            if (StringUtils.isNotBlank((String)form.getDates().getEndTime())) {
                try {
                    this.timeFormat.parse(form.getDates().getEndTime());
                }
                catch (ParseException e) {
                    errors.rejectValue("dates.endTime", "Invalid");
                }
            }
        }
    }
}

