/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.event.edition.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.calendar.common.model.Attachment;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.event.edition.portlet.model.CalendarEventEditionForm;
import org.osivia.services.calendar.event.edition.portlet.model.comparator.IndexComparator;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCalendarEventCommand
implements INuxeoCommand {
    @Autowired
    private IndexComparator indexComparator;

    public String getId() {
        return null;
    }

    protected PropertyMap getProperties(CalendarEventEditionForm form) {
        String colorId = form.getColor() == null ? null : form.getColor().getId();
        CalendarColor color = CalendarColor.fromId(colorId);
        if (color.equals((Object)form.getCalendarColor())) {
            colorId = null;
        }
        PropertyMap properties = new PropertyMap();
        properties.set("dc:title", form.getTitle());
        properties.set("vevent:dtstart", form.getStartDate());
        properties.set("vevent:dtend", form.getEndDate());
        properties.set("vevent:allDay", Boolean.valueOf(form.isAllDay()));
        properties.set("vevent:location", form.getLocation());
        properties.set("vevent:color", colorId);
        properties.set("note:note", form.getDescription());
        return properties;
    }

    protected void setAttachments(DocumentService documentService, Document document, CalendarEventEditionForm form) throws Exception {
        List<Attachment> files = form.getAttachments().getFiles();
        if (CollectionUtils.isNotEmpty(files)) {
            TreeSet<Integer> removedIndexes = new TreeSet<Integer>(this.indexComparator);
            for (Attachment file : files) {
                if (!file.isDeleted() || file.getIndex() == null) continue;
                removedIndexes.add(file.getIndex());
            }
            for (Integer index : removedIndexes) {
                StringBuilder xpath = new StringBuilder();
                xpath.append("files:files");
                xpath.append("/item[");
                xpath.append(index);
                xpath.append("]");
                documentService.removeBlob((DocRef)document, xpath.toString());
            }
            ArrayList<FileBlob> blobs = new ArrayList<FileBlob>(files.size());
            for (Attachment file : files) {
                File temporaryFile = file.getTemporaryFile();
                if (file.isDeleted() || temporaryFile == null) continue;
                String fileName = file.getTemporaryFileName();
                String mimeType = file.getTemporaryMimeType().getBaseType();
                FileBlob blob = new FileBlob(temporaryFile, fileName, mimeType);
                blobs.add(blob);
            }
            if (!blobs.isEmpty()) {
                documentService.setBlobs((DocRef)document, new Blobs(blobs), "files:files");
                for (Attachment file : files) {
                    if (file.getTemporaryFile() == null) continue;
                    file.getTemporaryFile().delete();
                }
            }
        }
    }
}

