/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.view.portlet.controller;

import java.util.SortedMap;
import java.util.TreeMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.services.calendar.view.portlet.model.CalendarOptions;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepository;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"ADMIN"})
public class AdminCalendarController {
    private static final String ADMIN_PATH = "admin";
    private static final String CALENDAR_CONFIGURATION_ATTRIBUTE = "configuration";
    private static final String PERIOD_TYPES_ATTRIBUTE = "periodTypes";
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private CalendarViewRepository calendarRepository;
    @Autowired
    private IBundleFactory bundleFactory;

    @RenderMapping
    public String admin(RenderRequest request, RenderResponse response) throws PortletException {
        return ADMIN_PATH;
    }

    @ActionMapping(value="save")
    public void saveConfiguration(ActionRequest request, ActionResponse response, @ModelAttribute(value="configuration") CalendarOptions configuration) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.calendarRepository.saveConfiguration(portalControllerContext, configuration);
        response.setWindowState(WindowState.NORMAL);
        response.setPortletMode(PortletMode.VIEW);
    }

    @ModelAttribute(value="configuration")
    public CalendarOptions getConfiguration(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.calendarRepository.getConfiguration(portalControllerContext);
    }

    @ModelAttribute(value="periodTypes")
    public SortedMap<String, String> getPeriodTypes(PortletRequest request, PortletResponse response) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        TreeMap<String, String> periodTypes = new TreeMap<String, String>();
        for (PeriodTypes periodType : PeriodTypes.values()) {
            periodTypes.put(periodType.getName(), bundle.getString(periodType.getInternationalizationKey()));
        }
        return periodTypes;
    }
}

