/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.edition.portlet.controller;

import java.beans.PropertyEditor;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.osivia.services.calendar.common.model.converter.CalendarColorPropertyEditor;
import org.osivia.services.calendar.edition.portlet.model.CalendarEditionForm;
import org.osivia.services.calendar.edition.portlet.model.validation.CalendarFormValidator;
import org.osivia.services.calendar.edition.portlet.service.CalendarEditionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"form"})
public class CalendarEditionController {
    @Autowired
    protected PortletContext portletContext;
    @Autowired
    private CalendarEditionService service;
    @Autowired
    private CalendarFormValidator formValidator;
    @Autowired
    private CalendarColorPropertyEditor calendarColorPropertyEditor;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute(value="options") CalendarEditionOptions options) throws PortletException {
        String portletTitle = options.getPortletTitle();
        response.setTitle(portletTitle);
        return "view";
    }

    @ActionMapping(name="save", params={"upload-vignette"})
    public void uploadVignette(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") CalendarEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.uploadVignette(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"delete-vignette"})
    public void deleteVignette(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") CalendarEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.deleteVignette(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"edit-synchronization-source"})
    public void editSynchronizationSource(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") CalendarEditionForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.editSynchronizationSource(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"add-synchronization-source"})
    public void addSynchronizationSource(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") CalendarEditionForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.addSynchronizationSource(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"save"})
    public void save(ActionRequest request, ActionResponse response, @ModelAttribute(value="options") CalendarEditionOptions options, @Validated @ModelAttribute(value="form") CalendarEditionForm form, BindingResult result, SessionStatus status) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!result.hasErrors()) {
            this.service.save(portalControllerContext, options, form);
            status.setComplete();
        }
    }

    @ActionMapping(value="cancel")
    public void cancel(ActionRequest request, ActionResponse response, SessionStatus status) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.cancel(portalControllerContext);
        status.setComplete();
    }

    @ActionMapping(value="remove-synchronization-source")
    public void removeSynchronisationSource(ActionRequest request, ActionResponse response, @RequestParam(value="sourceId") String sourceId, @ModelAttribute(value="form") CalendarEditionForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.removeSynchronizationSource(portalControllerContext, form, sourceId);
    }

    @ResourceMapping(value="vignette-preview")
    public void vignettePreview(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") CalendarEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.vignettePreview(portalControllerContext, form);
    }

    @ResourceMapping(value="synchronization-source-edition-url")
    public void synchronizationSourceEditionUrl(ResourceRequest request, ResourceResponse response, @RequestParam(name="sourceId", required=false) String sourceId, @ModelAttribute(value="form") CalendarEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.synchronizationSourceEditionUrl(portalControllerContext, form, sourceId);
    }

    @ModelAttribute(value="options")
    public CalendarEditionOptions getOptions(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getEditionOptions(portalControllerContext);
    }

    @ModelAttribute(value="form")
    public CalendarEditionForm getForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }

    @InitBinder(value={"form"})
    public void formInitBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.formValidator});
        binder.registerCustomEditor(CalendarColor.class, (PropertyEditor)this.calendarColorPropertyEditor);
    }
}

