/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.contact.portlet.model.validation;

import org.apache.commons.codec.binary.StringUtils;
import org.osivia.services.contact.portlet.model.Form;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
public class ContactFormValidator
implements Validator {
    public boolean supports(Class<?> clazz) {
        return Form.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        Form form = (Form)target;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"from", (String)"NotEmpty");
        if (!errors.hasFieldErrors()) {
            boolean b1;
            String mail = form.getFrom();
            boolean bl = b1 = mail.contains("@") && mail.contains(".");
            if (!b1) {
                errors.rejectValue("from", "Invalid");
            }
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"nom", (String)"NotEmpty");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"object", (String)"NotEmpty");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"body", (String)"NotEmpty");
        if (!form.isCaptchaValidate()) {
            if (StringUtils.equals((CharSequence)form.getToken(), (CharSequence)form.getCaptcha())) {
                form.setCaptchaValidate(true);
            } else {
                errors.rejectValue("captcha", "Invalid");
            }
        }
    }
}

