/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.document.creation.plugin;

import fr.toutatice.portail.cms.nuxeo.api.player.INuxeoPlayerModule;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.impl.BasicPublicationInfos;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.player.Player;

public class DocumentCreationPlayer
implements INuxeoPlayerModule {
    private final IBundleFactory bundleFactory;
    private final Locale locale;

    public DocumentCreationPlayer(Locale locale) {
        this.locale = locale;
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public Player getCMSPlayer(DocumentContext<Document> docCtx) {
        BasicPublicationInfos basicPublicationInfos = (BasicPublicationInfos)docCtx.getPublicationInfos(BasicPublicationInfos.class);
        if (docCtx.getDoc() != null && StringUtils.equals((String)basicPublicationInfos.getDisplayContext(), (String)"onlyoffice")) {
            Bundle bundle = this.bundleFactory.getBundle(this.locale);
            HashMap<String, String> windowProperties = new HashMap<String, String>();
            windowProperties.put("osivia.cms.uri", ((Document)docCtx.getDoc()).getPath());
            windowProperties.put("osivia.hideTitle", "1");
            windowProperties.put("osivia.onlyoffice.withLock", Boolean.TRUE.toString());
            windowProperties.put("osivia.title", bundle.getString("ONLYOFFICE_EDIT"));
            Player onlyofficePlayer = new Player();
            onlyofficePlayer.setWindowProperties(windowProperties);
            onlyofficePlayer.setPortletInstance("osivia-services-onlyoffice-portletInstance");
            return onlyofficePlayer;
        }
        return null;
    }
}

