/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.document.creation.plugin;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPublicationInfos;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.tag.INuxeoTagService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.urls.PortalUrlType;

public class DocumentCreationMenubarModule
implements MenubarModule {
    public static final String DOC_TYPE_WINDOW_PARAM = "osivia.services.document.creation.type";
    public static final String DOCX_MIMETYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final String XLSX_MIMETYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String PPTX_MIMETYPE = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    private static final String DOCUMENT_CREATION_PORTLET = "osivia-services-document-creation-portletInstance";
    private final IMenubarService menubarService = (IMenubarService)Locator.findMBean(IMenubarService.class, (String)"osivia:service=MenubarService");
    private final IBundleFactory bundleFactory;
    private final INuxeoService nuxeoService;

    public DocumentCreationMenubarModule() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
    }

    public void customizeDocument(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext documentContext) throws PortalException {
        if (documentContext != null && documentContext.getDocument() instanceof Document && documentContext.getDocumentType() != null) {
            String typeName = documentContext.getDocumentType().getName();
            Document doc = (Document)documentContext.getDocument();
            String docPath = doc.getPath();
            if (StringUtils.equals((String)typeName, (String)"Folder")) {
                NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
                NuxeoPublicationInfos publicationInfos = ((NuxeoDocumentContext)documentContext).getPublicationInfos();
                boolean acceptFiles = publicationInfos.getSubtypes().contains("File");
                if (acceptFiles) {
                    Element pptxIcon;
                    Element xlsxIcon;
                    Element docxIcon;
                    INuxeoTagService tagService = this.nuxeoService.getTagService();
                    Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
                    MenubarDropdown addDropdown = this.getAddDropdown(portalControllerContext, bundle);
                    try {
                        docxIcon = tagService.getMimeTypeIcon(nuxeoController, DOCX_MIMETYPE, null);
                    }
                    catch (IOException e) {
                        throw new PortalException((Exception)e);
                    }
                    MenubarItem createWordDocument = new MenubarItem("NEW_WORD_DOCUMENT", bundle.getString("NEW_WORD_DOCUMENT"), null, (MenubarContainer)addDropdown, 10, "javascript:;", null, null, null);
                    createWordDocument.setCustomizedIcon(docxIcon);
                    createWordDocument.getData().put("target", "#osivia-modal");
                    createWordDocument.getData().put("load-url", this.getDocumentWordCreationPortletUrl(nuxeoController, docPath));
                    menubar.add(createWordDocument);
                    try {
                        xlsxIcon = tagService.getMimeTypeIcon(nuxeoController, XLSX_MIMETYPE, null);
                    }
                    catch (IOException e) {
                        throw new PortalException((Exception)e);
                    }
                    MenubarItem createExcelDocument = new MenubarItem("NEW_EXCEL_DOCUMENT", bundle.getString("NEW_EXCEL_DOCUMENT"), null, (MenubarContainer)addDropdown, 11, "#", null, null, null);
                    createExcelDocument.setCustomizedIcon(xlsxIcon);
                    createExcelDocument.getData().put("target", "#osivia-modal");
                    createExcelDocument.getData().put("load-url", this.getDocumentExcelCreationPortletUrl(nuxeoController, docPath));
                    menubar.add(createExcelDocument);
                    try {
                        pptxIcon = tagService.getMimeTypeIcon(nuxeoController, PPTX_MIMETYPE, null);
                    }
                    catch (IOException e) {
                        throw new PortalException((Exception)e);
                    }
                    MenubarItem createPowerpointDocument = new MenubarItem("NEW_POWERPOINT_DOCUMENT", bundle.getString("NEW_POWERPOINT_DOCUMENT"), null, (MenubarContainer)addDropdown, 12, "#", null, null, null);
                    createPowerpointDocument.setCustomizedIcon(pptxIcon);
                    createPowerpointDocument.getData().put("target", "#osivia-modal");
                    createPowerpointDocument.getData().put("load-url", this.getDocumentPowerpointCreationPortletUrl(nuxeoController, docPath));
                    menubar.add(createPowerpointDocument);
                }
            }
        }
    }

    private MenubarDropdown getAddDropdown(PortalControllerContext portalControllerContext, Bundle bundle) {
        MenubarDropdown addDropdown = this.menubarService.getDropdown(portalControllerContext, "ADD");
        if (addDropdown == null) {
            addDropdown = new MenubarDropdown("ADD", bundle.getString("ADD"), "halflings halflings-plus", MenubarGroup.CMS, 2);
            this.menubarService.addDropdown(portalControllerContext, addDropdown);
        }
        return addDropdown;
    }

    private String getDocumentWordCreationPortletUrl(NuxeoController nuxeoController, String currentDocPath) throws PortalException {
        return this.getDocumentCreationPortletUrl(nuxeoController, DOCX_MIMETYPE, currentDocPath);
    }

    private String getDocumentExcelCreationPortletUrl(NuxeoController nuxeoController, String currentDocPath) throws PortalException {
        return this.getDocumentCreationPortletUrl(nuxeoController, XLSX_MIMETYPE, currentDocPath);
    }

    private String getDocumentPowerpointCreationPortletUrl(NuxeoController nuxeoController, String currentDocPath) throws PortalException {
        return this.getDocumentCreationPortletUrl(nuxeoController, PPTX_MIMETYPE, currentDocPath);
    }

    private String getDocumentCreationPortletUrl(NuxeoController nuxeoController, String docTypeParam, String currentDocPath) throws PortalException {
        HashMap<String, String> windowProperties = new HashMap<String, String>(2);
        windowProperties.put(DOC_TYPE_WINDOW_PARAM, docTypeParam);
        windowProperties.put("osivia.cms.uri", currentDocPath);
        return nuxeoController.getPortalUrlFactory().getStartPortletUrl(nuxeoController.getPortalCtx(), DOCUMENT_CREATION_PORTLET, windowProperties, PortalUrlType.MODAL);
    }

    public void customizeSpace(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext spaceDocumentContext) throws PortalException {
    }
}

