/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.controller;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.edition.portlet.model.AbstractDocumentEditionForm;
import org.osivia.services.edition.portlet.model.validator.DocumentEditionFormValidator;
import org.osivia.services.edition.portlet.service.DocumentEditionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"form"})
public class DocumentEditionController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private DocumentEditionService service;
    @Autowired
    private DocumentEditionFormValidator validator;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        return this.service.getViewPath(portalControllerContext);
    }

    @ActionMapping(name="submit", params={"upload"})
    public void upload(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") AbstractDocumentEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.upload(portalControllerContext, form);
    }

    @ActionMapping(name="submit", params={"restore"})
    public void restore(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") AbstractDocumentEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.restore(portalControllerContext, form);
    }

    @ActionMapping(name="submit", params={"save"})
    public void save(ActionRequest request, ActionResponse response, @Validated @ModelAttribute(value="form") AbstractDocumentEditionForm form, BindingResult result, SessionStatus sessionStatus) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!result.hasErrors()) {
            sessionStatus.setComplete();
            this.service.save(portalControllerContext, form);
        }
    }

    @ActionMapping(value="cancel")
    public void cancel(ActionRequest request, ActionResponse response, SessionStatus sessionStatus) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        sessionStatus.setComplete();
        this.service.cancel(portalControllerContext);
    }

    @ModelAttribute(value="form")
    public AbstractDocumentEditionForm getForm(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }

    @InitBinder(value={"form"})
    public void editionFormInitBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.validator});
        binder.setDisallowedFields(new String[]{"name", "creation", "path", "originalTitle"});
    }

    @ExceptionHandler(value={MultipartException.class})
    String handleFileException(Throwable ex, RenderRequest request, RenderResponse response) {
        request.setAttribute("uploadMaxSize", (Object)DocumentEditionService.MAX_UPLOAD_SIZE);
        return "upload-error";
    }
}

