/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.edition.portlet.model.FileEditionForm;
import org.osivia.services.edition.portlet.repository.FileEditionRepositoryImpl;
import org.osivia.services.edition.portlet.repository.command.ImportZipCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;

@Repository(value="Zip")
public class ZipRepositoryImpl
extends FileEditionRepositoryImpl {
    private static final String BINARY_PROPERTY = "file:content";
    private static final String BINARY_NAME_PROPERTY = "file:filename";
    private static final Log logger = LogFactory.getLog((String)"org.osivia.collaboration");
    @Value(value="#{systemProperties['osivia.filebrowser.zip.uploadsizelimit'] ?: null}")
    private String zipSizeLimit;
    @Value(value="#{systemProperties['osivia.filebrowser.zip.uploadweightlimit'] ?: null}")
    private String zipWeightLimit;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public void validate(FileEditionForm form, Errors errors) {
        if (form.getTemporaryFile() == null) {
            errors.rejectValue("upload", "NotEmpty");
        } else {
            String originalFilename = form.getTemporaryFileName();
            if (!StringUtils.endsWithIgnoreCase((String)originalFilename, (String)".zip")) {
                errors.rejectValue("upload", "InvalidFileType", null);
            } else {
                try {
                    this.checkLimits(form, errors);
                }
                catch (IOException e) {
                    errors.rejectValue("upload", "InvalidFileType", null);
                }
            }
        }
    }

    @Override
    protected Document create(NuxeoController nuxeoController, String parentPath, String type, PropertyMap properties, Map<String, Blob> binaries) throws PortletException {
        Blob binary = binaries.get(BINARY_PROPERTY);
        if (binary == null) {
            throw new PortletException("Empty file");
        }
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(ImportZipCommand.class, new Object[]{parentPath, binary});
        Document document = (Document)nuxeoController.executeNuxeoCommand(command);
        return document;
    }

    private void checkLimits(FileEditionForm form, Errors errors) throws ZipException, IOException {
        long startTime = new Date().getTime();
        int sizeLimit = 0;
        long weightLimit = 0L;
        if (this.zipSizeLimit != null) {
            sizeLimit = Integer.parseInt(this.zipSizeLimit.trim());
        }
        if (this.zipWeightLimit != null) {
            weightLimit = NumberUtils.toLong((String)this.zipWeightLimit.trim()) * 0x100000L;
        }
        int totalEntries = 0;
        File f = form.getTemporaryFile();
        long totalWeight = f.length();
        ZipFile zipFile = new ZipFile(f);
        totalEntries += zipFile.size();
        boolean nuxeoArchive = false;
        Enumeration<? extends ZipEntry> enu = zipFile.entries();
        while (enu.hasMoreElements()) {
            ZipEntry zipEntry = enu.nextElement();
            if (!zipEntry.getName().equals(".nuxeo-archive")) continue;
            nuxeoArchive = true;
            break;
        }
        zipFile.close();
        if (nuxeoArchive) {
            this.logWarn("W01", form.getRemoteUser(), startTime, "D\u00e9p\u00f4t d'un fichier zip nuxeo archive");
            errors.rejectValue("upload", "InvalidZipNuxeoArchive", null);
            f.delete();
        }
        long s = totalWeight / 0x100000L;
        long l = weightLimit / 0x100000L;
        if (sizeLimit > 0 && totalEntries > sizeLimit) {
            this.logWarn("W02", form.getRemoteUser(), startTime, "D\u00e9p\u00f4t d'un fichier zip contenant trop d'entr\u00e9es. " + totalEntries + " \u00e9l\u00e9ments et " + s + "Mo (limites " + sizeLimit + " et " + l + "Mo)");
            errors.rejectValue("upload", "InvalidZipTooManyEntries", (Object[])new String[]{Integer.toString(totalEntries), Integer.toString(sizeLimit)}, null);
            f.delete();
        }
        if (weightLimit > 0L && totalWeight > weightLimit) {
            this.logWarn("W03", form.getRemoteUser(), startTime, "D\u00e9p\u00f4t d'un fichier zip trop volumineux. " + totalEntries + " \u00e9l\u00e9ments et " + s + "Mo (limites " + sizeLimit + " et " + l + "Mo)");
            errors.rejectValue("upload", "InvalidZipTooBig", (Object[])new String[]{Long.toString(s), Long.toString(l)}, null);
            f.delete();
        }
        this.log("I02", form.getRemoteUser(), startTime, "D\u00e9p\u00f4t d'un fichier zip contenant " + totalEntries + " \u00e9l\u00e9ments et " + s + "Mo (limites " + sizeLimit + " et " + l + "Mo)");
    }

    private void log(String code, String owner, long startTime, String message) {
        long stopTime = System.currentTimeMillis();
        long elapsedTime = stopTime - startTime;
        logger.info((Object)(code + " " + owner + " FileBrowserService " + elapsedTime + " " + message));
    }

    private void logWarn(String code, String owner, long startTime, String message) {
        long stopTime = System.currentTimeMillis();
        long elapsedTime = stopTime - startTime;
        logger.warn((Object)(code + " " + owner + " FileBrowserService " + elapsedTime + " " + message));
    }
}

