/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.edition.portlet.model.AbstractDocumentEditionForm;
import org.osivia.services.edition.portlet.model.DocumentEditionWindowProperties;
import org.osivia.services.edition.portlet.repository.DocumentEditionRepository;
import org.osivia.services.edition.portlet.repository.command.CheckTitleAvailabilityCommand;
import org.osivia.services.edition.portlet.repository.command.CreateDocumentCommand;
import org.osivia.services.edition.portlet.repository.command.UpdateDocumentCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.web.portlet.context.PortletContextAware;

public abstract class AbstractDocumentEditionRepositoryImpl<T extends AbstractDocumentEditionForm>
implements PortletContextAware,
DocumentEditionRepository<T> {
    protected static final String TITLE_PROPERTY = "dc:title";
    protected static final String DESCRIPTION_PROPERTY = "dc:description";
    private PortletContext portletContext;
    @Autowired
    private ApplicationContext applicationContext;

    protected AbstractDocumentEditionRepositoryImpl() {
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    @Override
    public boolean matches(String documentType, boolean creation) {
        return false;
    }

    @Override
    public NuxeoDocumentContext getDocumentContext(PortalControllerContext portalControllerContext, String path) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        return nuxeoController.getDocumentContext(path);
    }

    @Override
    public T getForm(PortalControllerContext portalControllerContext, DocumentEditionWindowProperties windowProperties) throws PortletException, IOException {
        Class type = this.getParameterizedType();
        AbstractDocumentEditionForm form = (AbstractDocumentEditionForm)this.applicationContext.getBean(type);
        if (StringUtils.isNotEmpty((String)windowProperties.getDocumentPath())) {
            NuxeoDocumentContext documentContext = this.getDocumentContext(portalControllerContext, windowProperties.getDocumentPath());
            Document document = documentContext.getDocument();
            String title = document.getTitle();
            form.setTitle(title);
            form.setOriginalTitle(title);
            String description = document.getString(DESCRIPTION_PROPERTY);
            form.setDescription(description);
            this.customizeForm(portalControllerContext, document, form);
        }
        return (T)form;
    }

    protected void customizeForm(PortalControllerContext portalControllerContext, Document document, T form) throws PortletException, IOException {
    }

    private T castForm(AbstractDocumentEditionForm form) {
        Class type = this.getParameterizedType();
        return (T)((AbstractDocumentEditionForm)type.cast(form));
    }

    @Override
    public void validate(AbstractDocumentEditionForm form, Errors errors) {
        this.customizeValidation(this.castForm(form), errors);
    }

    protected void customizeValidation(T form, Errors errors) {
        boolean available;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"title", (String)"NotEmpty");
        if (!(!((AbstractDocumentEditionForm)form).isCreation() && StringUtils.equalsIgnoreCase((String)((AbstractDocumentEditionForm)form).getOriginalTitle(), (String)((AbstractDocumentEditionForm)form).getTitle()) || (available = this.checkTitleAvailability(form)))) {
            errors.rejectValue("title", "Unavailable");
        }
    }

    private boolean checkTitleAvailability(T form) {
        NuxeoController nuxeoController = new NuxeoController(this.portletContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        DocumentEditionWindowProperties windowProperties = ((AbstractDocumentEditionForm)form).getWindowProperties();
        String parentPath = ((AbstractDocumentEditionForm)form).isCreation() ? windowProperties.getParentDocumentPath() : StringUtils.substringBeforeLast((String)windowProperties.getDocumentPath(), (String)"/");
        NuxeoDocumentContext parentDocumentContext = nuxeoController.getDocumentContext(parentPath);
        Document parentDocument = parentDocumentContext.getDocument();
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(CheckTitleAvailabilityCommand.class, new Object[]{parentDocument.getId(), ((AbstractDocumentEditionForm)form).getTitle()});
        Boolean available = (Boolean)nuxeoController.executeNuxeoCommand(command);
        return BooleanUtils.isTrue((Boolean)available);
    }

    @Override
    public void upload(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form) throws PortletException, IOException {
        this.customizeUpload(portalControllerContext, this.castForm(form));
    }

    protected void customizeUpload(PortalControllerContext portalControllerContext, T form) throws PortletException, IOException {
    }

    @Override
    public void restore(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form) throws PortletException, IOException {
        this.customizeRestore(portalControllerContext, this.castForm(form));
    }

    protected void customizeRestore(PortalControllerContext portalControllerContext, T form) throws PortletException, IOException {
    }

    @Override
    public void save(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        PropertyMap properties = new PropertyMap();
        properties.set(TITLE_PROPERTY, form.getTitle());
        properties.set(DESCRIPTION_PROPERTY, StringUtils.trimToNull((String)form.getDescription()));
        HashMap<String, List<Blob>> binaries = new HashMap<String, List<Blob>>();
        this.customizeProperties(portalControllerContext, this.castForm(form), properties, binaries);
        if (form.isCreation()) {
            DocumentEditionWindowProperties windowProperties = form.getWindowProperties();
            String parentPath = windowProperties.getParentDocumentPath();
            String documentType = windowProperties.getDocumentType();
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(parentPath);
            DocumentType parentDocumentType = documentContext.getDocumentType();
            if (parentDocumentType == null || !parentDocumentType.getSubtypes().contains(documentType)) {
                throw new PortletException("Invalid created document type.");
            }
            Document document = this.create(nuxeoController, parentPath, documentType, properties, binaries);
            if (document != null) {
                form.setPath(document.getPath());
            }
        } else {
            this.update(nuxeoController, form.getPath(), properties, binaries);
        }
    }

    protected void customizeProperties(PortalControllerContext portalControllerContext, T form, PropertyMap properties, Map<String, List<Blob>> binaries) throws PortletException, IOException {
    }

    protected Document create(NuxeoController nuxeoController, String parentPath, String type, PropertyMap properties, Map<String, List<Blob>> binaries) throws PortletException, IOException {
        CreateDocumentCommand command = (CreateDocumentCommand)this.applicationContext.getBean(CreateDocumentCommand.class);
        command.setParentPath(parentPath);
        command.setType(type);
        command.setProperties(properties);
        command.setBinaries(binaries);
        return (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
    }

    protected void update(NuxeoController nuxeoController, String path, PropertyMap properties, Map<String, List<Blob>> binaries) throws PortletException, IOException {
        UpdateDocumentCommand command = (UpdateDocumentCommand)this.applicationContext.getBean(UpdateDocumentCommand.class);
        command.setPath(path);
        command.setProperties(properties);
        command.setBinaries(binaries);
        nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
    }
}

