/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.PortletException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.edition.portlet.model.FileEditionForm;
import org.osivia.services.edition.portlet.repository.AbstractDocumentEditionRepositoryImpl;
import org.osivia.services.edition.portlet.repository.command.ImportFilesCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.springframework.web.multipart.MultipartFile;

@Repository
public class FileEditionRepositoryImpl
extends AbstractDocumentEditionRepositoryImpl<FileEditionForm> {
    private static final String BINARY_PROPERTY = "file:content";
    private static final String BINARY_NAME_PROPERTY = "file:filename";
    private final Set<String> acceptedDocumentTypes = Stream.of("File", "Picture", "Audio", "Video").collect(Collectors.toSet());
    private final Map<String, String> requiredPrimaryTypes = new ConcurrentHashMap<String, String>();
    @Autowired
    private ApplicationContext applicationContext;

    public FileEditionRepositoryImpl() {
        this.requiredPrimaryTypes.put("Picture", "image");
        this.requiredPrimaryTypes.put("Audio", "audio");
        this.requiredPrimaryTypes.put("Video", "video");
    }

    @Override
    public Class<FileEditionForm> getParameterizedType() {
        return FileEditionForm.class;
    }

    @Override
    public boolean matches(String documentType, boolean creation) {
        return !creation && this.acceptedDocumentTypes.contains(documentType);
    }

    @Override
    protected void customizeForm(PortalControllerContext portalControllerContext, Document document, FileEditionForm form) {
        String requiredPrimaryType = this.requiredPrimaryTypes.get(document.getType());
        form.setRequiredPrimaryType(requiredPrimaryType);
        form.setOriginalFileName(document.getProperties().getString(this.getBinaryNameProperty()));
    }

    @Override
    public String getViewPath(PortalControllerContext portalControllerContext) {
        return "file";
    }

    @Override
    public void customizeValidation(FileEditionForm form, Errors errors) {
        super.customizeValidation(form, errors);
        if (form.isCreation()) {
            if (form.getTemporaryFile() == null) {
                errors.rejectValue("upload", "NotEmpty");
            }
        } else if (form.getTemporaryFile() != null && StringUtils.isNotEmpty((String)form.getRequiredPrimaryType())) {
            MimeType mimeType = form.getTemporaryFileMimeType();
            if (mimeType == null) {
                errors.rejectValue("upload", "UnknownFileType");
            } else if (!StringUtils.equals((String)form.getRequiredPrimaryType(), (String)mimeType.getPrimaryType())) {
                errors.rejectValue("upload", "InvalidFileType");
            }
        }
    }

    @Override
    public void customizeUpload(PortalControllerContext portalControllerContext, FileEditionForm form) throws IOException {
        MimeType mimeType;
        if (form.getTemporaryFile() != null && !form.getTemporaryFile().delete()) {
            form.getTemporaryFile().deleteOnExit();
        }
        MultipartFile upload = form.getUpload();
        File temporaryFile = File.createTempFile("document-edition-file-", ".tmp");
        temporaryFile.deleteOnExit();
        upload.transferTo(temporaryFile);
        form.setTemporaryFile(temporaryFile);
        form.setTemporaryFileName(upload.getOriginalFilename());
        try {
            mimeType = new MimeType(upload.getContentType());
        }
        catch (MimeTypeParseException e) {
            mimeType = null;
        }
        form.setTemporaryFileMimeType(mimeType);
        if (StringUtils.isBlank((String)form.getTitle())) {
            form.setTitle(form.getTemporaryFileName());
        }
    }

    @Override
    public void customizeRestore(PortalControllerContext portalControllerContext, FileEditionForm form) {
        if (form.getTemporaryFile() != null && !form.getTemporaryFile().delete()) {
            form.getTemporaryFile().deleteOnExit();
        }
        form.setTemporaryFile(null);
        form.setTemporaryFileName(null);
        form.setTemporaryFileMimeType(null);
    }

    @Override
    protected void customizeProperties(PortalControllerContext portalControllerContext, FileEditionForm form, PropertyMap properties, Map<String, List<Blob>> binaries) {
        if (form.getTemporaryFile() != null) {
            File file = form.getTemporaryFile();
            String contentType = form.getTemporaryFileMimeType() == null ? null : form.getTemporaryFileMimeType().toString();
            String s = Normalizer.normalize(form.getTemporaryFileName(), Normalizer.Form.NFC);
            FileBlob blob = new FileBlob(file, s, contentType);
            binaries.put(this.getBinaryProperty(), Collections.singletonList(blob));
        }
    }

    @Override
    protected Document create(NuxeoController nuxeoController, String parentPath, String type, PropertyMap properties, Map<String, List<Blob>> binaries) throws PortletException {
        List<Blob> blobs = binaries.get(this.getBinaryProperty());
        if (CollectionUtils.isEmpty(blobs)) {
            throw new PortletException("Empty file");
        }
        ImportFilesCommand command = (ImportFilesCommand)this.applicationContext.getBean(ImportFilesCommand.class);
        command.setParentPath(parentPath);
        command.setBinaries(blobs);
        return (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
    }

    protected String getBinaryProperty() {
        return BINARY_PROPERTY;
    }

    protected String getBinaryNameProperty() {
        return BINARY_NAME_PROPERTY;
    }
}

