/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository;

import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.activation.MimeType;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.edition.portlet.model.AbstractDocumentEditionForm;
import org.osivia.services.edition.portlet.model.ExistingFile;
import org.osivia.services.edition.portlet.model.FileEditionForm;
import org.osivia.services.edition.portlet.model.UploadTemporaryFile;
import org.osivia.services.edition.portlet.repository.AbstractDocumentEditionRepositoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.springframework.web.multipart.MultipartFile;

@Repository
public class FileEditionRepositoryImpl
extends AbstractDocumentEditionRepositoryImpl<FileEditionForm> {
    private static final String BINARY_PROPERTY = "file:content";
    private static final String BINARY_NAME_PROPERTY = "file:filename";
    private final Set<String> acceptedDocumentTypes = Stream.of("File", "Picture", "Audio", "Video").collect(Collectors.toSet());
    private final Map<String, String> requiredPrimaryTypes = new ConcurrentHashMap();
    @Autowired
    private ApplicationContext applicationContext;

    public FileEditionRepositoryImpl() {
        this.requiredPrimaryTypes.put("Picture", "image");
        this.requiredPrimaryTypes.put("Audio", "audio");
        this.requiredPrimaryTypes.put("Video", "video");
    }

    public Class<FileEditionForm> getParameterizedType() {
        return FileEditionForm.class;
    }

    public boolean matches(String documentType, boolean creation) {
        return !creation && this.acceptedDocumentTypes.contains(documentType);
    }

    protected void customizeForm(PortalControllerContext portalControllerContext, Document document, FileEditionForm form) {
        ExistingFile existingFile = (ExistingFile)this.applicationContext.getBean(ExistingFile.class);
        existingFile.setFileName(document.getProperties().getString(BINARY_NAME_PROPERTY));
        form.setExistingFile(existingFile);
        String requiredPrimaryType = (String)this.requiredPrimaryTypes.get(document.getType());
        form.setRequiredPrimaryType(requiredPrimaryType);
    }

    public String getViewPath(PortalControllerContext portalControllerContext) {
        return "file";
    }

    public void customizeValidation(FileEditionForm form, Errors errors) {
        super.customizeValidation((AbstractDocumentEditionForm)form, errors);
        if (form.isCreation()) {
            if (form.getTemporaryFile() == null || form.getTemporaryFile().getFile() == null) {
                errors.rejectValue("upload", "NotEmpty");
            }
        } else if (form.getTemporaryFile() != null && form.getTemporaryFile().getFile() != null && StringUtils.isNotEmpty((String)form.getRequiredPrimaryType())) {
            MimeType mimeType = form.getTemporaryFile().getMimeType();
            if (mimeType == null) {
                errors.rejectValue("upload", "UnknownFileType");
            } else if (!StringUtils.equals((String)form.getRequiredPrimaryType(), (String)mimeType.getPrimaryType())) {
                errors.rejectValue("upload", "InvalidFileType");
            }
        }
    }

    public void customizeUpload(PortalControllerContext portalControllerContext, FileEditionForm form) throws IOException {
        if (form.getTemporaryFile() != null && form.getTemporaryFile().getFile() != null && !form.getTemporaryFile().getFile().delete()) {
            form.getTemporaryFile().getFile().deleteOnExit();
        }
        MultipartFile upload = form.getUpload();
        UploadTemporaryFile temporaryFile = this.createTemporaryFile(upload);
        form.setTemporaryFile(temporaryFile);
        if (StringUtils.isBlank((String)form.getTitle())) {
            form.setTitle(form.getTemporaryFile().getFileName());
        }
    }

    public void customizeRestore(PortalControllerContext portalControllerContext, FileEditionForm form) {
        if (form.getTemporaryFile() != null && form.getTemporaryFile().getFile() != null && !form.getTemporaryFile().getFile().delete()) {
            form.getTemporaryFile().getFile().deleteOnExit();
        }
        form.setTemporaryFile(null);
    }

    protected void customizeProperties(PortalControllerContext portalControllerContext, FileEditionForm form, PropertyMap properties, Map<String, List<Blob>> binaries) {
        if (form.getTemporaryFile() != null && form.getTemporaryFile().getFile() != null) {
            File file = form.getTemporaryFile().getFile();
            String contentType = form.getTemporaryFile().getMimeType() == null ? null : form.getTemporaryFile().getMimeType().toString();
            String s = Normalizer.normalize(form.getTemporaryFile().getFileName(), Normalizer.Form.NFC);
            FileBlob blob = new FileBlob(file, s, contentType);
            binaries.put(BINARY_PROPERTY, Collections.singletonList(blob));
        }
    }
}

