/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.edition.portlet.model.DocumentEditionMetadata;
import org.osivia.services.edition.portlet.model.ExistingFile;
import org.osivia.services.edition.portlet.model.Picture;
import org.osivia.services.edition.portlet.model.UploadTemporaryFile;
import org.osivia.services.edition.portlet.repository.DocumentEditionCommonRepositoryImpl;
import org.osivia.services.edition.portlet.repository.DocumentEditionMetadataRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;

@Repository
public class DocumentEditionMetadataRepositoryImpl
extends DocumentEditionCommonRepositoryImpl<DocumentEditionMetadata>
implements DocumentEditionMetadataRepository {
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public DocumentEditionMetadata get(PortalControllerContext portalControllerContext, Document document) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        DocumentEditionMetadata metadata = (DocumentEditionMetadata)this.applicationContext.getBean(DocumentEditionMetadata.class);
        Picture vignette = (Picture)this.applicationContext.getBean(Picture.class);
        metadata.setVignette(vignette);
        if (document != null) {
            ExistingFile existingFile;
            String description = document.getString("dc:description");
            metadata.setDescription(description);
            PropertyMap vignettePropertyMap = document.getProperties().getMap("ttc:vignette");
            if (vignettePropertyMap == null || StringUtils.isEmpty((String)vignettePropertyMap.getString("data"))) {
                existingFile = null;
            } else {
                existingFile = (ExistingFile)this.applicationContext.getBean(ExistingFile.class);
                String url = nuxeoController.createFileLink(document, "ttc:vignette");
                existingFile.setDownloadUrl(url);
            }
            vignette.setExistingFile(existingFile);
        }
        return metadata;
    }

    @Override
    public void validate(DocumentEditionMetadata metadata, Errors errors) {
        String primaryType;
        Picture vignette = metadata.getVignette();
        UploadTemporaryFile temporaryFile = vignette.getTemporaryFile();
        if (temporaryFile != null && !StringUtils.equals((String)"image", (String)(primaryType = temporaryFile.getMimeType() == null ? null : temporaryFile.getMimeType().getPrimaryType()))) {
            errors.rejectValue("metadata.vignette.upload", "InvalidFileType");
        }
    }

    @Override
    public void customizeProperties(PortalControllerContext portalControllerContext, DocumentEditionMetadata metadata, boolean creation, PropertyMap properties, Map<String, List<Blob>> binaries) throws PortletException {
        Picture vignette;
        if (!creation || StringUtils.isNotBlank((String)metadata.getDescription())) {
            properties.set("dc:description", StringUtils.trimToNull((String)metadata.getDescription()));
        }
        if ((vignette = metadata.getVignette()).getTemporaryFile() != null && vignette.getTemporaryFile().getFile() != null) {
            File file = vignette.getTemporaryFile().getFile();
            FileBlob blob = new FileBlob(file);
            binaries.put("ttc:vignette", Collections.singletonList(blob));
        } else if (vignette.isDeleted()) {
            binaries.put("ttc:vignette", null);
        }
    }
}

